package com.bxm.localnews.thirdparty.service.pop;

import com.bxm.localnews.thirdparty.service.pop.popinstance.Pop;
import com.bxm.localnews.thirdparty.service.pop.popinstance.impl.*;
import com.bxm.localnews.thirdparty.service.pop.popstrategy.PopStrategy;
import com.bxm.localnews.thirdparty.service.pop.popstrategy.impl.AbstractPopStrategy;
import com.bxm.localnews.thirdparty.service.pop.popstrategy.impl.PopDailyStrategy;
import com.bxm.localnews.thirdparty.service.pop.popstrategy.impl.PopDefaultStrategy;
import com.bxm.localnews.thirdparty.service.pop.popstrategy.impl.PopOnceStrategy;
import com.google.common.collect.Maps;

import java.util.HashMap;
import java.util.Map;

/**
 * 弹窗处理器配置，弹窗策略，排序，数值越小，处理器的优先级越高，排序过后的处理器会形成处理器链
 */
public class PopConfig {

    private static Map<Class<? extends Pop>, PopConfigParam> popConfigMap = Maps.newHashMap();

    /**
     * -1:隐私弹窗配置
     * 0:插屏广告弹窗配置
     * 1:版本弹窗配置
     * 2：VIP激活弹窗
     * 3:活动弹窗配置
     * 4:投票弹窗配置
     * 5:个人主页弹窗配置
     * 6:红包弹窗配置
     * 7:引导提现弹窗配置
     * 8:完善资料【暂时未使用】
     * 9：广告弹窗配置
     * 10：VIP弹窗配置
     * 11：小纸条发布数弹窗配置
     * 12：首页注册来源为话题的话题弹窗配置
     * 13：vip页面tab引导弹窗配置
     *
     * 999：默认弹窗
     */
    //构造PopConfigParam时，order、strategyClass、key必传，可根据弹窗策略传入num、dayNum实现额外控制
    static {

        int order = 0;

        // 隐私弹窗配置
        popConfigMap.put(PrivacyPop.class,
                PopConfigParam.builder()
                        .order(order++)
                        .strategyClass(PopOnceStrategy.class)
                        .key(PopTypeEnum.PRIVACY_POP.name())
                        .build());


        // 3.9.0版本用户引导弹窗
        popConfigMap.put(NewVersionGuidePop.class,
                PopConfigParam.builder()
                        .order(order++)
                        .strategyClass(PopOnceStrategy.class)
                        .key(PopTypeEnum.NEW_GUIDE_POP.name())
                        .build());

        // 普通用户引导弹窗
        popConfigMap.put(NormalUserGuidePop.class,
                PopConfigParam.builder()
                        .order(order++)
                        .strategyClass(PopOnceStrategy.class)
                        .key(PopTypeEnum.NORMAL_GUIDE_POP.name())
                        .build());
        // vip用户引导弹窗
        popConfigMap.put(VipUserGuidePop.class,
                PopConfigParam.builder()
                        .order(order++)
                        .strategyClass(PopOnceStrategy.class)
                        .key(PopTypeEnum.VIP_GUIDE_POP.name())
                        .build());

        // 3.11.0vip页面tab引导弹窗配置
        popConfigMap.put(VipPageTabPop.class,
                PopConfigParam.builder()
                        .order(order++)
                        .strategyClass(PopOnceStrategy.class)
                        .key(PopTypeEnum.VIP_PAGE_TAB_POP.name())
                        .build());

        //插屏广告弹窗配置
        popConfigMap.put(ThrustAdvertPop.class,
                PopConfigParam.builder()
                        .order(order++)
                        .strategyClass(PopDailyStrategy.class)
                        .key(PopTypeEnum.THRUST_ADVERT_POP.name())
                        .build()
        );

        //版本弹窗配置
        popConfigMap.put(VersionPop.class,
                PopConfigParam.builder()
                        .order(order++)
                        .strategyClass(PopDefaultStrategy.class)
                        .key(PopTypeEnum.VERSION_POP.name())
                        .build()
        );

        //VIP激活弹窗
        popConfigMap.put(VipActivePop.class,
                PopConfigParam.builder()
                        .order(order++)
                        .strategyClass(PopOnceStrategy.class)
                        .key(PopTypeEnum.VIP_ACTIVATION_SUCCESS.name())
                        .build()
        );
        //站外激活VIP但是没有次数了
        popConfigMap.put(VipNotSuccessActivePop.class,
                PopConfigParam.builder()
                        .order(order++)
                        .strategyClass(PopOnceStrategy.class)
                        .key(PopTypeEnum.ACTIVATION_HAS_NOT_CHANCE.name())
                        .build()
        );
        //活动弹窗配置
        popConfigMap.put(ActivityPop.class,
                PopConfigParam.builder()
                        .order(order++)
                        .strategyClass(PopDailyStrategy.class)
                        .key(PopTypeEnum.ACTIVITY_POP.name())
                        .build()
        );

        //投票弹窗配置
        popConfigMap.put(VotePop.class,
                PopConfigParam.builder()
                        .order(order++)
                        .strategyClass(PopOnceStrategy.class)
                        .key(PopTypeEnum.VOTE_POP.name())
                        .build()
        );

        //个人主页弹窗配置
        popConfigMap.put(HomePagePop.class,
                PopConfigParam.builder()
                        .order(order++)
                        .strategyClass(PopOnceStrategy.class)
                        .key(PopTypeEnum.HOME_PAGE_POP.name())
                        .build()
        );

        //红包弹窗配置
        popConfigMap.put(RedPackagePop.class,
                PopConfigParam.builder()
                        .order(order++)
                        .strategyClass(PopDefaultStrategy.class)
                        .key(PopTypeEnum.RED_PACKAGE_POP.name())
                        .build()
        );

        //引导提现弹窗配置
        popConfigMap.put(WithdrawPop.class,
                PopConfigParam.builder()
                        .order(order++)
                        .strategyClass(PopDefaultStrategy.class)
                        .key(PopTypeEnum.WITHDRAW_POP.name())
                        .build()
        );

        //广告弹窗配置
        popConfigMap.put(AdvertPop.class,
                PopConfigParam.builder()
                        .order(order++)
                        .strategyClass(PopDefaultStrategy.class)
                        .key(PopTypeEnum.ADVERT_POP.name())
                        .build()
        );

        //小纸条发布数弹窗配置
        popConfigMap.put(NoteNumPop.class,
                PopConfigParam.builder()
                        .order(order++)
                        .strategyClass(PopDailyStrategy.class)
                        .key(PopTypeEnum.NOTE_NUM_POP.name())
                        .build()
        );

        // 首页注册来源为话题的话题弹窗配置
        popConfigMap.put(TopicPop.class,
                PopConfigParam.builder()
                        .order(order++)
                        .strategyClass(PopOnceStrategy.class)
                        .key(PopTypeEnum.HOME_TOPIC_POP.name())
                        .build()
        );

        //默认弹窗配置
        popConfigMap.put(DefaultPop.class,
                PopConfigParam.builder()
                        .order(order++)
                        .strategyClass(PopDefaultStrategy.class)
                        .build()
        );


    }

    public static int getOrder(Pop pop) {
        return popConfigMap.get(pop.getClass()).getOrder();
    }

    public static Class<? extends PopStrategy> getStrategy(Class<? extends Pop> clazz) {
        return popConfigMap.get(clazz).getStrategyClass();
    }

    public static Map<String, Object> getParam(Class<? extends Pop> clazz) {
        Map<String, Object> param = new HashMap<>();

        PopConfigParam configParam = popConfigMap.get(clazz);
        param.put(AbstractPopStrategy.KEY, configParam.getKey());
        param.put(AbstractPopStrategy.NUM, configParam.getNum());
        param.put(AbstractPopStrategy.DAY_NUM, configParam.getDayNum());

        return param;
    }


}
