package com.bxm.localnews.thirdparty.service.pop;

import com.bxm.localnews.thirdparty.dto.HomeWindowDTO;
import com.bxm.localnews.thirdparty.param.HomeWindowParam;
import com.bxm.localnews.thirdparty.service.pop.popinstance.Pop;
import com.bxm.localnews.thirdparty.service.pop.popinstance.PopCache;
import com.bxm.localnews.thirdparty.service.pop.popinstance.PopContext;
import com.bxm.localnews.thirdparty.service.pop.popstrategy.PopStrategy;
import com.bxm.localnews.thirdparty.service.pop.popstrategy.impl.AbstractPopStrategy;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

@Slf4j
@Service
public class PopFactory implements ApplicationContextAware {

    private ApplicationContext applicationContext;

    private Pop firstPop;

    private static final Map<Class<? extends PopStrategy>, PopStrategy> POP_STRATEGY_MAP = new HashMap<>();

    @Autowired
    private RedisHashMapAdapter redisHashMapAdapter;

    /**
     * 根据传入参数获取弹窗结果
     *
     * @param homeWindowParam
     * @return
     */
    public HomeWindowDTO process(HomeWindowParam homeWindowParam) {
        if (log.isDebugEnabled()) {
            log.debug("开始处理弹窗，开始时间：" + System.currentTimeMillis());
        }

        //初始化缓存map，比对长度后增量
        Map<String, PopCache> cacheMap = redisHashMapAdapter.entries(
                AbstractPopStrategy.getRedisKey(homeWindowParam.getUserId()), PopCache.class);

        PopContext popContext = new PopContext();
        popContext.setHomeWindowParam(homeWindowParam);
        popContext.setCacheMap(cacheMap);

        firstPop.process(popContext);

        if (log.isDebugEnabled()) {
            log.debug("结束处理弹窗，结束时间：" + System.currentTimeMillis());
        }

        return popContext.getHomeWindowDTO();
    }

    @EventListener(ApplicationReadyEvent.class)
    public void onApplicationEvent(ApplicationReadyEvent event) {
        // 处理弹窗策略
        Collection<PopStrategy> popStrategyList = this.applicationContext.getBeansOfType(PopStrategy.class).values();
        popStrategyList.forEach(popStrategy -> POP_STRATEGY_MAP.put(popStrategy.getClass(), popStrategy));

        // 处理pop实例
        Collection<Pop> popList = this.applicationContext.getBeansOfType(Pop.class).values();
        popList.forEach(pop -> {
            Class<? extends PopStrategy> popStrategy = PopConfig.getStrategy(pop.getClass());
            if (null != popStrategy) {
                pop.setPopStrategy(POP_STRATEGY_MAP.get(popStrategy));
            }
            pop.setParam(PopConfig.getParam(pop.getClass()));
        });

        List<Pop> result = popList.stream().sorted(Comparator.comparingInt(PopConfig::getOrder)).collect(Collectors.toList());
        for (int i = 0; i < result.size() - 1; i++) {
            result.get(i).setNext(result.get(i + 1));
        }

        this.firstPop = result.get(0);
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}
