package com.bxm.localnews.thirdparty.service.pop.popinstance;

import com.bxm.localnews.thirdparty.dto.HomeWindowDTO;
import com.bxm.localnews.thirdparty.param.HomeWindowParam;
import com.google.common.collect.Maps;
import lombok.Data;

import java.util.Map;

/**
 * 弹窗策略上下文
 */
@Data
public class PopContext {

    /**
     * 个人弹窗传参实体
     */
    private HomeWindowParam homeWindowParam;

    /**
     * 个人弹窗返回结果实体
     */
    private HomeWindowDTO homeWindowDTO;

    /**
     * 个人弹窗缓存信息
     */
    private Map<String, PopCache> cacheMap;

    /**
     * 执行过程中的参数map
     */
    private Map<String, Object> paramMap = Maps.newHashMap();

    /**
     * 调用过程中添加参数
     *
     * @param key   参数的键值
     * @param value 键值对应的值
     */
    public PopContext addParam(String key, Object value) {
        this.paramMap.put(key, value);
        return this;
    }

    /**
     * 获取消息传递的参数信息
     *
     * @return 参数MAP
     */
    public Map<String, Object> getParamMap() {
        return this.paramMap;
    }

    /**
     * 获取消息传递的参数信息
     *
     * @return 参数MAP
     */
    public <T> T getParam(String key) {
        return (T) this.paramMap.get(key);
    }

}
