package com.bxm.localnews.thirdparty.service.pop.popinstance.impl;

import com.bxm.localnews.activity.service.HelpInfoFacadeService;
import com.bxm.localnews.thirdparty.dto.HomeWindowDTO;
import com.bxm.localnews.thirdparty.param.HomeWindowParam;
import com.bxm.localnews.thirdparty.service.pop.PopTypeEnum;
import com.bxm.localnews.thirdparty.service.pop.popinstance.PopContext;
import com.bxm.newidea.component.tools.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 活动弹窗
 */
@Slf4j
@Service
public class ActivityPop extends AbstractPop {

    @Autowired
    private HelpInfoFacadeService helpInfoFacadeService;

    @Override
    public boolean filter(PopContext context) {
        log.debug("开始处理活动弹窗，开始时间：" + System.currentTimeMillis());
        boolean result = false;

        HomeWindowParam homeWindowParam = context.getHomeWindowParam();
        String homeWindowUrl = helpInfoFacadeService.getHomeWindowUrl(
                homeWindowParam.getUserId(), homeWindowParam.getAreaCode(), homeWindowParam.getAreaName());
        if (StringUtils.isNotBlank(homeWindowUrl)) {
            context.setHomeWindowDTO(new HomeWindowDTO(PopTypeEnum.ACTIVITY_POP.getType(), homeWindowUrl));
            result = true;
        }

        log.debug("结束处理活动弹窗，结束时间：" + System.currentTimeMillis());
        return result;
    }

}
