package com.bxm.localnews.thirdparty.service.pop.popinstance.impl;

import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.thirdparty.dto.HomeWindowDTO;
import com.bxm.localnews.thirdparty.service.pop.PopTypeEnum;
import com.bxm.localnews.thirdparty.service.pop.popinstance.PopContext;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Calendar;
import java.util.Date;
import java.util.Random;

/**
 * 小纸条发布数弹窗
 */
@Slf4j
@Service
public class NoteNumPop extends AbstractPop {

    @Autowired
    private RedisStringAdapter redisStringAdapter;

    @Override
    public boolean filter(PopContext context) {
        return false;
    }

    /**
     * 3.4.0版本移出小纸条发布数弹窗 代码备份
     * @param context context
     * @return true: 弹出
     */
    private boolean backup(PopContext context) {
        log.debug("开始处理小纸条发布数弹窗，开始时间：" + System.currentTimeMillis());
        boolean result = false;

        Date now = new Date();
        Integer dayNum1 = redisStringAdapter.getInt(getNoteDailyPublishNum(DateUtils.addField(now, Calendar.DAY_OF_MONTH, -2)));
        Integer dayNum2 = redisStringAdapter.getInt(getNoteDailyPublishNum(DateUtils.addField(now, Calendar.DAY_OF_MONTH, -1)));
        Integer dayNum3 = redisStringAdapter.getInt(getNoteDailyPublishNum(now));

        int noteNum = 0;

        if (dayNum1 != null) {
            noteNum += dayNum1;
        }
        if (dayNum2 != null) {
            noteNum += dayNum2;
        }
        if (dayNum3 != null) {
            noteNum += dayNum3;
        }

        if (noteNum > 0) {
            noteNum += 20 + new Random().nextInt(30);
            HomeWindowDTO homeWindowDTO = new HomeWindowDTO();
            homeWindowDTO.setType(PopTypeEnum.NOTE_NUM_POP.getType());
            homeWindowDTO.setNoteRemind("有" + noteNum + "人发布了纸条，期待你的互动");
            context.setHomeWindowDTO(homeWindowDTO);
            result = true;
        }

        log.debug("结束处理小纸条发布数弹窗，结束时间：" + System.currentTimeMillis());
        return result;
    }

    private KeyGenerator getNoteDailyPublishNum(Date date) {
        return RedisConfig.NOTE_DAILY_PUBLISH_NUM.copy().appendKey(DateUtils.formatDate(date));
    }

}
