package com.bxm.localnews.thirdparty.service.pop.popinstance.impl;

import com.bxm.localnews.common.config.PrivacyAgreementProperties;
import com.bxm.localnews.thirdparty.dto.HomeWindowDTO;
import com.bxm.localnews.thirdparty.dto.PrivacyAgreementDTO;
import com.bxm.localnews.thirdparty.service.pop.PopTypeEnum;
import com.bxm.localnews.thirdparty.service.pop.popinstance.PopContext;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 隐私弹窗
 *
 * @author wzy
 * @date 2020/8/13 19:01
 **/
@Slf4j
@Service
public class PrivacyPop extends AbstractPop {

    @Resource
    private PrivacyAgreementProperties privacyAgreementProperties;

    @Override
    boolean filter(PopContext context) {
        HomeWindowDTO homeWindowDTO = new HomeWindowDTO();
        PrivacyAgreementDTO privacyAgreementDTO = new PrivacyAgreementDTO();
        privacyAgreementDTO.setText(privacyAgreementProperties.getText());
        List<PrivacyAgreementDTO.JumpAddress> replaceList = new ArrayList<>();
        for (Map<String, String> jumpAddress : privacyAgreementProperties.getReplace()) {
            PrivacyAgreementDTO.JumpAddress address = new PrivacyAgreementDTO.JumpAddress();
            address.setName(jumpAddress.get("name"));
            address.setJumpUrl(jumpAddress.get("jumpUrl"));
            replaceList.add(address);
        }
        privacyAgreementDTO.setReplace(replaceList);
        homeWindowDTO.setPrivacyAgreementDTO(privacyAgreementDTO);
        homeWindowDTO.setType(PopTypeEnum.PRIVACY_POP.getType());
        context.setHomeWindowDTO(homeWindowDTO);
        return true;
    }

    @Override
    public void afterFilter(PopContext context) {
        // 不进行缓存，弹窗上报的时候才进行缓存
    }
}
