package com.bxm.localnews.thirdparty.service.pop.popinstance.impl;

import com.bxm.localnews.base.service.AppVersionSupplyService;
import com.bxm.localnews.common.dto.AppVersionDTO;
import com.bxm.localnews.thirdparty.dto.HomeWindowDTO;
import com.bxm.localnews.thirdparty.param.HomeWindowParam;
import com.bxm.localnews.thirdparty.service.pop.PopTypeEnum;
import com.bxm.localnews.thirdparty.service.pop.popinstance.PopContext;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 版本控制弹窗
 */
@Slf4j
@Service
public class VersionPop extends AbstractPop {

    @Autowired
    private AppVersionSupplyService appVersionSupplyService;

    @Override
    public boolean filter(PopContext context) {
        log.debug("开始处理版本弹窗，开始时间：" + System.currentTimeMillis());
        boolean result = false;

        HomeWindowParam homeWindowParam = context.getHomeWindowParam();
        AppVersionDTO appVersionDTO = appVersionSupplyService.getAppVersion(homeWindowParam, homeWindowParam.getIp());

        if (appVersionDTO != null && appVersionDTO.getIsForce() != null
                && ((byte) 0 == appVersionDTO.getIsForce()
                || (byte) 1 == appVersionDTO.getIsForce())) {
            HomeWindowDTO homeWindowDTO = new HomeWindowDTO();
            homeWindowDTO.setAppVersionDTO(appVersionDTO);
            homeWindowDTO.setType(PopTypeEnum.VERSION_POP.getType());
            context.setHomeWindowDTO(homeWindowDTO);
            result = true;
        }

        log.debug("结束处理版本弹窗，结束时间：" + System.currentTimeMillis());
        return result;
    }

}
