/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.thirdparty.service.pop.popinstance.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.common.constant.UserActiveVipEnum;
import com.bxm.localnews.common.dto.ExpandWindowDTO;
import com.bxm.localnews.common.rediskey.UserRedisKey;
import com.bxm.localnews.thirdparty.dto.HomeWindowDTO;
import com.bxm.localnews.thirdparty.service.pop.PopTypeEnum;
import com.bxm.localnews.thirdparty.service.pop.popinstance.PopContext;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * @author jieliGG
 * @date 2020/7/18 16:25
 * VIP 没有成功激活弹窗
 **/
@Service
@Slf4j
public class VipNotSuccessActivePop  extends AbstractPop {
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;

    @Override
    boolean filter(PopContext context) {
        boolean flag = false;
        HomeWindowDTO homeWindowDTO = new HomeWindowDTO();
        homeWindowDTO.setType(PopTypeEnum.ACTIVATION_HAS_NOT_CHANCE.getType());
        String info = redisHashMapAdapter.get(UserRedisKey.ACTIVE_VIP_HAS_NOT_CHANCE,String.valueOf(context.getHomeWindowParam().getUserId()),String.class);
        if(StringUtils.isEmpty(info) || info.equals(UserActiveVipEnum.DONOT_NEED.getCode()+"")){
        }else{
            flag = true;
            redisHashMapAdapter.put(UserRedisKey.ACTIVE_VIP_HAS_NOT_CHANCE,String.valueOf(context.getHomeWindowParam().getUserId()), UserActiveVipEnum.DONOT_NEED.getCode()+"");
            //加载素材信息
            ExpandWindowDTO expandWindowDTO = new ExpandWindowDTO();
            expandWindowDTO.setJumpUrl("wst://function/tabbarIndex?className_iOS=TTNormalWebVC");
            expandWindowDTO.setAndroidJumpUrl("wst://function/tabbarIndex?tabName=vip");
            //弹窗内容在user那边配置的，redis存什么，这边弹什么
            expandWindowDTO.setTitle(info);
            homeWindowDTO.setExpandWindowDTO(expandWindowDTO);
            log.debug("弹窗VipNotSuccessActivePop成功了！！！！！！");
        }
        context.setHomeWindowDTO(homeWindowDTO);
        return flag;
    }
}
