package com.bxm.localnews.thirdparty.service.pop.popinstance.impl;

import com.bxm.localnews.common.dto.LocationDetailDTO;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.thirdparty.config.PopupProperties;
import com.bxm.localnews.thirdparty.dto.HomeWindowDTO;
import com.bxm.localnews.thirdparty.dto.VipNoviceUserGuideDTO;
import com.bxm.localnews.thirdparty.param.HomeWindowParam;
import com.bxm.localnews.thirdparty.service.pop.PopTypeEnum;
import com.bxm.localnews.thirdparty.service.pop.popinstance.PopContext;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import static java.util.Objects.isNull;

/**
 * vip用户的引导弹窗
 * 3.6.0之后的改动是VIP弹窗点击之后没有接下来其他的引导，对于服务端来说不需要动VIP引导弹窗的逻辑
 *
 * @author gonzo
 * @date 2020-08-21 13:54
 **/
@Component
@Slf4j
@AllArgsConstructor
public class VipUserGuidePop extends AbstractGuidePopup {

    private final UserIntegrationService userIntegrationService;

    private final PopupProperties popupProperties;

    @Override
    boolean filter(PopContext context) {
        // 调用公共的校验
        if (!super.filter(context)) {
            return false;
        }

        HomeWindowParam param = context.getHomeWindowParam();
        LocationDetailDTO locationDetailDTO = context.getParam(LOCATION_DETAIL_DTO);

        if (isNull(locationDetailDTO)) {
            log.warn("城市: {}信息获取失败 跳过非vip用户的引导弹窗", param.getAreaCode());
            return false;
        }

        // 查询用户信息
        UserInfoDTO userInfo = userIntegrationService.getUserFromRedisDB(param.getUserId());
        if (isNull(userInfo)) {
            log.warn("用户: {} 不存在，跳过vip用户的引导弹窗", param.getUserId());
            return false;
        }

        // 判断用户是新版本注册用户
        if (!check350JudgeMarker(userInfo.getJudgeMarker())) {
            log.info("用户: {} 非新版本用户 增加弹出缓存，永不弹出", param.getUserId());
            super.closeCache(context);
            return false;
        }

        // 判断用户是否有上级 如果没有上级则表示是站外购买的
        if (isNull(userInfo.getInviteUserId())) {
            log.info("用户: {} 非邀请VIP用户 增加弹出缓存，永不弹出", param.getUserId());
            super.closeCache(context);
            return false;
        }

        // 是否是站外邀请激活而来的VIP
        if (!isInviteVip(userInfo)) {
            log.info("用户: {}非激活邀请的VIP 增加VIP新用户弹窗的弹出缓存，永不弹出", param.getUserId());
            super.closeCache(context);
            return false;
        }

        // 查询上级信息
        String nickName = "";
        UserInfoDTO superInfo = userIntegrationService.getUserFromRedisDB(userInfo.getInviteUserId());
        if (isNull(superInfo)) {
            log.warn("用户: {} 上级用户用户: {} 不存在，弹窗数据缺失", param.getUserId(), userInfo.getInviteUserId());
        } else {
            nickName = superInfo.getNickname();
        }

        VipNoviceUserGuideDTO guideDTO = new VipNoviceUserGuideDTO();
        guideDTO.setUserId(param.getUserId());
        guideDTO.setImgUrl(userInfo.getHeadImg());
        // 这里 需要的是师傅的昵称
        guideDTO.setNickName(StringUtils.join("您的好友", nickName));
        guideDTO.setContent(String.format(popupProperties.getVipNoviceUserGuideContent(), locationDetailDTO.getName()));

        HomeWindowDTO windowDTO = new HomeWindowDTO();
        windowDTO.setType(PopTypeEnum.VIP_GUIDE_POP.getType());
        windowDTO.setVipNoviceUserGuide(guideDTO);

        context.setHomeWindowDTO(windowDTO);

        return true;
    }

    @Override
    protected String afterIncludeVersion() {
        return VER_3_5_0;
    }

    @Override
    protected String beforeExcludeVersion() {
        return "";
    }


}
