package com.bxm.localnews.thirdparty.service.pop.popinstance.impl;

import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.dto.VoteHomeDTO;
import com.bxm.localnews.integration.ForumPostIntegrationService;
import com.bxm.localnews.integration.NewsIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.thirdparty.dto.HomeWindowDTO;
import com.bxm.localnews.thirdparty.param.HomeWindowParam;
import com.bxm.localnews.thirdparty.service.pop.PopTypeEnum;
import com.bxm.localnews.thirdparty.service.pop.popinstance.PopContext;
import com.bxm.localnews.vo.ForumPostBriefInfoDto;
import com.bxm.localnews.vo.NewsBriefInfoDto;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

import static com.bxm.localnews.common.constant.RedisConfig.CONTENT_GUIDE_KEY;

/**
 * 投票弹窗
 */
@Slf4j
@Service
public class VotePop extends AbstractPop {

    @Autowired
    private RedisSetAdapter redisSetAdapter;

    @Autowired
    private UserIntegrationService userIntegrationService;

    @Autowired
    private ForumPostIntegrationService forumPostIntegrationService;

    @Autowired
    private NewsIntegrationService newsIntegrationService;

    @Override
    public boolean filter(PopContext context) {
        log.debug("开始处理投票弹窗，开始时间：" + System.currentTimeMillis());
        boolean result = false;

        HomeWindowParam homeWindowParam = context.getHomeWindowParam();
        VoteHomeDTO voteHome = getVotePost(homeWindowParam.getUserId(), homeWindowParam.getAreaCode(), homeWindowParam.getAreaName());
        if (null != voteHome) {
            HomeWindowDTO homeWindowDTO = new HomeWindowDTO();
            homeWindowDTO.setVoteHomeDTO(voteHome);
            homeWindowDTO.setType(PopTypeEnum.VOTE_POP.getType());
            context.setHomeWindowDTO(homeWindowDTO);
            result = true;
        }

        log.debug("结束处理投票弹窗，结束时间：" + System.currentTimeMillis());
        return result;
    }

    /**
     * 得到投票弹窗的属性
     *
     * @param userId
     * @param areaCode
     * @param areaName
     * @return
     */
    private VoteHomeDTO getVotePost(Long userId, String areaCode, String areaName) {
        //判断用户是否有过投票引导弹窗
        if (!redisSetAdapter.exists(CONTENT_GUIDE_KEY, userId)) {
            UserInfoDTO userInfo = userIntegrationService.getUserFromRedisDB(userId);

            if (Objects.nonNull(userInfo)) {
                //此方法只能调用一次，不管是否匹配，后续都不再判断
                //redisSetAdapter.add(CONTENT_GUIDE_KEY, userId);

                //判断用户是否为帖子注册
                if (null != userInfo.getInviteUserId()) {
                    if (InviteTypeEnum.FORUM.getName().equalsIgnoreCase(userInfo.getRegisterChannel())) {
                        ForumPostBriefInfoDto postInfo = forumPostIntegrationService.getPostBriefInfo(userInfo.getRelationId(), userId, areaCode, areaName);
                        if (postInfo.getId() == null) {
                            return null;
                        }

                        return VoteHomeDTO.builder()
                                .coverImg(postInfo.getConvertImgUrl())
                                .title(postInfo.getTitle())
                                .id(postInfo.getId())
                                .hasVote(postInfo.getHasVote())
                                .type("FORUM")
                                .build();
                    } else if (InviteTypeEnum.NEWS.getName().equalsIgnoreCase(userInfo.getRegisterChannel())) {
                        NewsBriefInfoDto newsInfo = newsIntegrationService.getPostBriefInfo(userInfo.getRelationId(), userId, areaCode);
                        if (newsInfo == null || newsInfo.getId() == null) {
                            return null;
                        }

                        return VoteHomeDTO.builder()
                                .coverImg(newsInfo.getConvertImgUrl())
                                .title(newsInfo.getTitle())
                                .id(newsInfo.getId())
                                .hasVote(newsInfo.getHasVote())
                                .type("NEWS")
                                .build();
                    }
                }
            }
        }
        return null;
    }

}
