package com.bxm.localnews.thirdparty.service.pop.popinstance.impl;

import com.bxm.localnews.dto.UserAccountDTO;
import com.bxm.localnews.integration.UserAccountIntegrationService;
import com.bxm.localnews.thirdparty.dto.HomeWindowDTO;
import com.bxm.localnews.thirdparty.param.HomeWindowParam;
import com.bxm.localnews.thirdparty.service.pop.PopTypeEnum;
import com.bxm.localnews.thirdparty.service.pop.popinstance.PopContext;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 引导提现弹窗
 */
@Slf4j
@Service
public class WithdrawPop extends AbstractPop {

    @Autowired
    private UserAccountIntegrationService userAccountIntegrationService;

    @Override
    public boolean filter(PopContext context) {
        log.debug("开始处理引导提现弹窗，开始时间：" + System.currentTimeMillis());
        boolean result = false;

        HomeWindowParam homeWindowParam = context.getHomeWindowParam();
        UserAccountDTO userAccountDTO = userAccountIntegrationService.getUserAccount(homeWindowParam.getUserId());

        if (userAccountDTO != null && userAccountDTO.getEnablePopWithdraw() != null && userAccountDTO.getEnablePopWithdraw()) {
            HomeWindowDTO homeWindowDTO = new HomeWindowDTO();
            homeWindowDTO.setUserAccountDTO(userAccountDTO);
            homeWindowDTO.setType(PopTypeEnum.WITHDRAW_POP.getType());
            context.setHomeWindowDTO(homeWindowDTO);
            result = true;
        }

        log.debug("结束处理引导提现弹窗，结束时间：" + System.currentTimeMillis());
        return result;
    }

}
