package com.bxm.localnews.thirdparty.service.pop.popstrategy.impl;

import com.bxm.localnews.thirdparty.service.pop.popinstance.PopCache;
import com.bxm.localnews.thirdparty.service.pop.popinstance.PopContext;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

@Service
@Slf4j
/**
 * 每周一一次弹窗策略
 */
public class DaysApartStrategy extends AbstractPopStrategy {
    /**
     * 最后弹出时间
     */
    public static final String LAST_MODIFY_TIME = "lastModifyTime";

    @Autowired
    private RedisHashMapAdapter redisHashMapAdapter;

    @Override
    public boolean judge(PopContext popContext) {
        //获取弹窗的key
        String subKey = popContext.getParam(KEY);
        //相隔多少天弹窗
        Integer dayNum = popContext.getParam(DAY_NUM);
        if (null == dayNum) {
            dayNum = 7;
        }

        //用户弹窗缓存map
        PopCache cache = popContext.getCacheMap().get(subKey);
        if (Objects.nonNull(cache) && !cache.isPopUp()) {
            //获取是否弹窗的标识
            return Boolean.FALSE;
        }
        if (Objects.isNull(cache)) {
            popContext.getCacheMap().put(subKey, new PopCache());
            return Boolean.TRUE;
        }

        Long dayTime = cache.getParam(LAST_MODIFY_TIME);
        return (System.currentTimeMillis() - dayTime) > dayNum * DateUtils.DAY_MILLISECOND;
    }

    @Override
    public void cache(PopContext popContext) {
        String subKey = popContext.getParamMap().get(KEY).toString();
        popContext.getCacheMap().get(subKey).addParam(DaysApartStrategy.LAST_MODIFY_TIME, System.currentTimeMillis());
        redisHashMapAdapter.put(getRedisKey(popContext.getHomeWindowParam().getUserId()),
                subKey, popContext.getCacheMap().get(subKey));
    }
}
