package com.bxm.localnews.thirdparty.service.pop.popstrategy.impl;

import com.bxm.localnews.thirdparty.service.pop.popinstance.PopCache;
import com.bxm.localnews.thirdparty.service.pop.popinstance.PopContext;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.DateUtils;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * 每日弹窗策略
 */
@Service
public class PopDailyStrategy extends AbstractPopStrategy {

    /**
     * 每日弹窗缓存map key
     */
    private static final String DAILY = "daily";

    @Autowired
    private RedisHashMapAdapter redisHashMapAdapter;

    @Override
    public boolean judge(PopContext popContext) {
        //获取弹窗的key
        String subKey = popContext.getParam(KEY);

        //获取弹窗的指定每天弹出次数
        Integer settingNum = popContext.getParam(NUM);
        if (null == settingNum) {
            settingNum = 1;
        }

        //用户弹窗缓存map
        PopCache cache = popContext.getCacheMap().get(subKey);

        String dailyKey = DateUtils.formatDate(new Date());
        if (null != cache) {
            //当前弹窗的缓存map  <date,num>
            Map<String, Object> dailyMap = cache.getParam(DAILY);

            if (dailyMap != null) {
                //得到弹窗的数量
                int num = dailyMap.get(dailyKey) == null ? 0 : (Integer) dailyMap.get(dailyKey);
                if (num < settingNum) {
                    int updateNum = num + 1;
                    dailyMap.put(dailyKey, updateNum);
                    cache.addParam(DAILY, dailyMap);
                    return true;
                }
            } else {
                dailyMap = new HashMap<>();
                dailyMap.put(dailyKey, 1);
                cache.addParam(DAILY, dailyMap);
                return true;
            }
        } else {
            cache = new PopCache();
            Map<String, Object> dailyMap = new HashMap<>();
            dailyMap.put(dailyKey, 1);
            cache.addParam(DAILY, dailyMap);
            popContext.getCacheMap().put(subKey, cache);
            return true;
        }
        return false;
    }

    @Override
    public void cache(PopContext popContext) {
        String subKey = popContext.getParamMap().get(KEY).toString();
        redisHashMapAdapter.put(getRedisKey(popContext.getHomeWindowParam().getUserId()),
                subKey, popContext.getCacheMap().get(subKey));
    }
}
