package com.bxm.localnews.thirdparty.service.strategy;

import com.bxm.localnews.thirdparty.config.WechatProperties;
import com.bxm.localnews.thirdparty.constant.WxMaTypeEnum;
import com.bxm.localnews.thirdparty.dto.WechatDto;
import com.bxm.localnews.thirdparty.dto.WxMaUserData;

import cn.binarywang.wx.miniapp.bean.WxMaJscode2SessionResult;
import cn.binarywang.wx.miniapp.bean.WxMaUserInfo;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.common.error.WxErrorException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author zhaoyadong 2019/5/24 10:08
 * @desc
 */
@Service
@Slf4j
public class AppletDrawServiceImpl extends AbstractStrategyService implements WxMinaAppStrategyService {

    @Autowired
    private WechatProperties wechatProperties;

    @Override
    public WxMaTypeEnum support() {
        return WxMaTypeEnum.APPLET_DRAW;
    }

    @Override
    public WxMaUserInfo getUserInfo(WxMaUserData wxMaUserData) {
        //备注：大转盘appid不是由前端传入，因此设置默认值
        if (StringUtils.isBlank(wxMaUserData.getAppId())) {
            wxMaUserData.setAppId(wechatProperties.getAppId());
        }

        return getWxMaService(wxMaUserData.getAppId()).getUserService().getUserInfo(wxMaUserData.getEncryptedData(),
                wxMaUserData.getSessionKey(), wxMaUserData.getIv());
    }

    @Override
    public WxMaJscode2SessionResult getOpenIdByCode(WechatDto wechatDto) {
        try {
            return getWxMaService(wechatDto.getAppId()).jsCode2SessionInfo(wechatDto.getCode());
        } catch (WxErrorException e) {
            log.error("微信小程序【大转盘】根据code获取openid错误, [{}]", e);
            return null;
        }
    }
}
