package com.bxm.localnews.thirdparty.service.wx.focus.handler;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.integration.UserAuthIntegrationService;
import com.bxm.localnews.integration.WxOfficialAccountService;
import com.bxm.localnews.thirdparty.config.WechatMPConfig;
import com.bxm.localnews.thirdparty.domain.WxOfficialLogMapper;
import com.bxm.localnews.thirdparty.vo.WxOfficialLog;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.mp.api.WxMpUserService;
import me.chanjar.weixin.mp.bean.result.WxMpUser;
import me.chanjar.weixin.mp.util.WxMpConfigStorageHolder;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;
import java.util.Objects;

import static org.apache.commons.lang3.StringUtils.isBlank;

/**
 * @author gonzo
 * @date 2020-12-23 23:11
 **/
@Slf4j
public class AbstractWxMpMessageHandler {

    @Autowired
    private WxMpUserService wxMpUserService;

    @Autowired
    private WxOfficialAccountService wxOfficialAccountService;

    @Autowired
    private UserAuthIntegrationService userAuthIntegrationService;

    @Autowired
    private WxOfficialLogMapper wxOfficialLogMapper;

    @Autowired
    protected WechatMPConfig wechatMPConfig;

    /**
     * 根据openid 获取用户信息
     *
     * @param openId openId
     * @return 用户信息
     */
    WxMpUser getWxMpUserByOpenId(String openId, String appId) {
        try {
            //  用之前先设置
            // TODO 这个地方把clear的设置放到后置拦截器里面做，避免每次调用都他妈的自己设置会default
            WxMpConfigStorageHolder.set(appId);
            WxMpUser wxMpUser = wxMpUserService.userInfo(openId);
            log.info("openID: {} 对应的wx用户信息: {}", openId, JSON.toJSON(wxMpUser));

            if (Objects.isNull(wxMpUser) || isBlank(wxMpUser.getUnionId())) {
                log.warn("openId: {} 获取微信用户信息失败", openId);
                return null;
            }
            // 根据微信uid获取用户id
            return wxMpUser;
        } catch (Exception e) {
            log.error("获取用户信息失败, openId: {}", openId, e);
        }

        return null;
    }

    void focusOnOfficialAccount(String openId, int status, String event, String appId) {
        //工具获取用户的unionid
        WxMpUser wxMpUser = getWxMpUserByOpenId(openId, appId);
        String unionId = wxMpUser == null ? "" : wxMpUser.getUnionId();
        if (status == 1 && null == wxMpUser) {
            log.warn("用微信openId获取userId失败, openId:{}", openId);
            // 记录日志方便排查
            WxOfficialLog wxOfficialLog = new WxOfficialLog(unionId, openId, event, new Date());
            wxOfficialLogMapper.insertSelective(wxOfficialLog);
            return;
        }
        // 记录日志方便排查
        WxOfficialLog wxOfficialLog = new WxOfficialLog(unionId, openId, event, new Date());
        wxOfficialLogMapper.insertSelective(wxOfficialLog);
        wxOfficialAccountService.focusOnOfficialAccount(openId, unionId, appId, status);
    }
}
