package com.bxm.localnews.thirdparty.service.wx.focus.handler;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.thirdparty.constant.WechatMpTypeEnum;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.mp.api.WxMpMessageHandler;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutMessage;
import org.springframework.stereotype.Component;

import java.util.Map;

import static org.apache.commons.lang3.StringUtils.isBlank;

/**
 * 微信关注事件处理类
 *
 * @author lowi
 */
@Component
@Slf4j
public class WxMpSubscribeHandler extends AbstractWxMpMessageHandler implements WxMpMessageHandler {



    @Override
    public WxMpXmlOutMessage handle(WxMpXmlMessage wxMessage, Map<String, Object> context, WxMpService wxMpService,
                                    WxSessionManager sessionManager) throws WxErrorException {

        try {
            log.info("处理关注事件:{}", JSON.toJSONString(wxMessage));

            // 获取配置用来接受微信回调的appId
            Map<String, String> appIdByType = wechatMPConfig.getAppIdByType();
            String appId = appIdByType.get(WechatMpTypeEnum.NOTIFY.name());
            focusOnOfficialAccount(isBlank(wxMessage.getOpenId()) ? wxMessage.getFromUser() : wxMessage.getOpenId(), 1, JSON.toJSONString(wxMessage),appId);
        } catch (Exception e) {
            log.error("处理关注事件失败 :{}", JSON.toJSONString(wxMessage), e);
        }
        return null;
    }
}
