package com.bxm.localnews.thirdparty.util;

import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.*;

public class SignUtil {

    private static final String SIGN_SEPARATOR = "\n";

    public static void main(String[] args) throws Exception {

        /** 构造请求 **/
        URI uri = new URIBuilder()
                .setScheme("https")
                .setHost("open-am.xiaojukeji.com/am/open/api")
                .setPath("/user/auth")
//                .setParameter("orderId", "111")
//                .setParameter("param1", "123")
//                .setParameter("param2", "124")
                .build();

        HttpPost request = new HttpPost(uri);

        /** 构造请求体 **/
        String body = "{\"encryptPhone\":\"BSneGm9NR+3KZSnaE3AKSA==\",\"deliveryMethod\":\"LINK\",\"openChannel\":1,\"bizLine\":\"ENERGY\"}";
        ContentType contentType = ContentType.APPLICATION_JSON;
        StringEntity se = new StringEntity(body, contentType);
        se.setContentEncoding("UTF-8");
        request.setEntity(se);

        /** 构造请求头 **/
        String appKey = "jxMvk6bmCziMB3qasTRk+3kwj1nAcJWUezZeJ45ukak=";
        request.setHeader("x-cas-key", appKey);

        String date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(new Date());
        request.setHeader("x-date", date);
        request.setHeader("content-type", contentType.getMimeType());
        request.setHeader("content-md5", md5Encrypt(body));

        /** 计算sign **/
        String appSecret = "EmVwHrP7Gtz796LW7hwBSJ7fSSHJMjXpY0yxlxrHNl4=";
        String signSource = buildSignSource(request.getMethod(), body, contentType.getMimeType(), date, appKey, uri.getPath(), uri.getQuery());
        String sign = calculateSign(signSource, appSecret);
        request.setHeader("sign", sign);

        /** 发送请求 **/
        CloseableHttpClient httpclient = HttpClients.createDefault();
        CloseableHttpResponse response = httpclient.execute(request);

        System.out.println(EntityUtils.toString(response.getEntity()));
    }

    /**
     * md5 加密
     */
    public static String md5Encrypt(String text) throws Exception {
        return DigestUtils.md5Hex(text);
    }

    /**
     * 拼接指定签名内容
     */
    public static String buildSignSource(String method, String body, String contentType, String date, String xCasKey, String path, String query) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(method.toUpperCase()).append(SIGN_SEPARATOR);
        if (Objects.nonNull(body)) {
            sb.append(md5Encrypt(body)).append(SIGN_SEPARATOR);
        }
        sb.append(contentType).append(SIGN_SEPARATOR);
        sb.append(date).append(SIGN_SEPARATOR);
        sb.append("x-cas-key:").append(xCasKey).append(SIGN_SEPARATOR);
        sb.append(path);
        if (Objects.nonNull(query)) {
            sb.append("?");
            sb.append(buildQueries(query));
        }
        return sb.toString();
    }

    private static String buildQueries(String query) {
        String[] queries = query.split("&");
        TreeMap<String, String> queryMap = new TreeMap<>();
        Arrays.stream(queries).forEach(queryItem -> {
            String[] keyValue = queryItem.split("=");
            queryMap.put(keyValue[0], keyValue[1]);
        });

        StringBuilder sb = new StringBuilder();
        queryMap.forEach((key, value) -> sb.append(key).append("=").append(value).append("&"));
        String result = sb.toString();
        if (result.endsWith("")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    /**
     * 计算签名
     */
    public static String calculateSign(String source, String accessSecret) throws InvalidKeyException {
        try {
            //HmacSHA256加密
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(accessSecret.getBytes("UTF-8"), "HmacSHA256"));
            byte[] signData = mac.doFinal(source.getBytes("UTF-8"));
            //bas64加密
            return Base64.getEncoder().encodeToString(signData);
        } catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("HMAC-SHA1 not supported.");
        } catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 not supported.");
        }

    }
}