/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.config;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.impl.WxMaServiceImpl;
import cn.binarywang.wx.miniapp.bean.WxMaKefuMessage;
import cn.binarywang.wx.miniapp.bean.WxMaMessage;
import cn.binarywang.wx.miniapp.bean.WxMaTemplateData;
import cn.binarywang.wx.miniapp.bean.WxMaTemplateMessage;
import cn.binarywang.wx.miniapp.builder.ImageMessageBuilder;
import cn.binarywang.wx.miniapp.builder.LinkMessageBuilder;
import cn.binarywang.wx.miniapp.builder.TextMessageBuilder;
import cn.binarywang.wx.miniapp.config.WxMaConfig;
import cn.binarywang.wx.miniapp.message.WxMaMessageHandler;
import cn.binarywang.wx.miniapp.message.WxMaMessageRouter;
import com.bxm.localnews.base.service.BaseUrlFacadeService;
import com.bxm.localnews.thirdparty.config.CustomApacheHttpClientBuilder;
import com.bxm.localnews.thirdparty.config.WxMaInRedisConfig;
import com.bxm.localnews.thirdparty.config.WxMaProperties;
import com.bxm.localnews.thirdparty.config.WxPortalCustomerProperties;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import me.chanjar.weixin.common.bean.result.WxMediaUploadResult;
import me.chanjar.weixin.common.error.WxErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.util.UriUtils;

@Configuration
@EnableConfigurationProperties(value={WxMaProperties.class})
public class WxMaConfiguration {
    private WxMaProperties properties;
    private RedisStringAdapter redisStringAdapter;
    private WxPortalCustomerProperties wxPortalCustomerProperties;
    private BaseUrlFacadeService baseUrlFacadeService;
    private CustomApacheHttpClientBuilder customApacheHttpClientBuilder;
    private static Map<String, WxMaMessageRouter> routers = Maps.newHashMap();
    private static Map<String, WxMaService> maServices = Maps.newHashMap();
    private static final Logger LOGGER = LoggerFactory.getLogger(WxMaConfiguration.class);
    private final WxMaMessageHandler templateMsgHandler = (wxMessage, context, service, sessionManager) -> service.getMsgService().sendTemplateMsg(WxMaTemplateMessage.builder().templateId("\u6b64\u5904\u66f4\u6362\u4e3a\u81ea\u5df1\u7684\u6a21\u677fid").formId("\u81ea\u5df1\u66ff\u6362\u53ef\u7528\u7684formid").data((List)Lists.newArrayList((Object[])new WxMaTemplateData[]{new WxMaTemplateData("keyword1", "339208499", "#173177")})).toUser(wxMessage.getFromUser()).build());
    private final WxMaMessageHandler logHandler = (wxMessage, context, service, sessionManager) -> LOGGER.info("\u6536\u5230\u6d88\u606f\uff1a[{}]", (Object)wxMessage.toString());
    private final WxMaMessageHandler picHandler = (wxMessage, context, service, sessionManager) -> {
        try {
            WxMediaUploadResult uploadResult = service.getMediaService().uploadMedia("image", "png", ClassLoader.getSystemResourceAsStream("tmp.png"));
            service.getMsgService().sendKefuMsg(((ImageMessageBuilder)WxMaKefuMessage.newImageBuilder().mediaId(uploadResult.getMediaId()).toUser(wxMessage.getFromUser())).build());
        }
        catch (WxErrorException e) {
            e.printStackTrace();
        }
    };
    private final WxMaMessageHandler qrcodeHandler = (wxMessage, context, service, sessionManager) -> {
        try {
            File file = service.getQrcodeService().createQrcode("123", 430);
            WxMediaUploadResult uploadResult = service.getMediaService().uploadMedia("image", file);
            service.getMsgService().sendKefuMsg(((ImageMessageBuilder)WxMaKefuMessage.newImageBuilder().mediaId(uploadResult.getMediaId()).toUser(wxMessage.getFromUser())).build());
        }
        catch (WxErrorException e) {
            e.printStackTrace();
        }
    };
    private final WxMaMessageHandler textHandler = (wxMessage, context, service, sessionManager) -> {
        LOGGER.info("\u6536\u5230\u7684\u6d88\u606f\uff1a[{}]", (Object)wxMessage.toString());
        String content = "";
        String url = "";
        if ("\u8054\u7cfb\u5b98\u65b9\u5ba2\u670d".equals(wxMessage.getTitle())) {
            LOGGER.debug("\u53d1\u9001\u5b98\u65b9\u5ba2\u670d\u56fe\u7247\u6d88\u606f");
            content = "\u8bf7\u70b9\u51fb\u4e0b\u65b9\u7684\u5fae\u4fe1\u4e8c\u7ef4\u7801\uff0c\u7136\u540e\u957f\u6309\u8bc6\u522b\uff0c\u6dfb\u52a0\u6211\u4e3a\u5fae\u4fe1\u597d\u53cb\u54e6~";
            url = this.wxPortalCustomerProperties.getOfficeCustomerUrl();
        } else if ("\u8054\u7cfb\u5728\u7ebf\u5ba2\u670d".equals(wxMessage.getTitle())) {
            content = "\u8bf7\u70b9\u51fb\u4e0b\u65b9\u7684\u5fae\u4fe1\u4e8c\u7ef4\u7801\uff0c\u7136\u540e\u957f\u6309\u8bc6\u522b\uff0c\u6dfb\u52a0\u6211\u4e3a\u5fae\u4fe1\u597d\u53cb\u54e6~";
            LOGGER.debug("\u53d1\u9001\u5728\u7ebf\u5ba2\u670d\u56fe\u7247\u6d88\u606f");
            url = this.wxPortalCustomerProperties.getOnlineCustomerUrl();
        } else if ("\u9080\u8bf7\u4f60\u8fdb\u5165\u5bb6\u4e61\u7fa4".equals(wxMessage.getTitle())) {
            LOGGER.debug("\u53d1\u9001\u5bb6\u4e61\u7fa4\u56fe\u7247\u6d88\u606f");
            content = "\u8bf7\u70b9\u51fb\u4e0b\u65b9\u7684\u5fae\u4fe1\u4e8c\u7ef4\u7801\uff0c\u7136\u540e\u957f\u6309\u8bc6\u522b\uff0c\u6dfb\u52a0\u5fae\u4fe1\u597d\u53cb\u540e\uff0c\u6211\u62c9\u4f60\u8fdb\u7fa4\u54e6~";
            url = this.wxPortalCustomerProperties.getHometownUrl();
        } else if ("\u672c\u5730\u4e07\u4e8b\u901a\u5b98\u65b9\u516c\u4f17\u53f7".equals(wxMessage.getTitle())) {
            LOGGER.debug("\u53d1\u9001\u5fae\u4fe1\u516c\u4f17\u53f7\u56fe\u7247\u6d88\u606f");
            content = "\u8bf7\u957f\u6309\u8bc6\u522b\u4e0b\u9762\u7684\u4e8c\u7ef4\u7801\u56fe\u7247\uff0c\u5173\u6ce8\u672c\u5730\u4e07\u4e8b\u901a\u516c\u4f17\u53f7\uff0c\u5373\u53ef\u9886\u53d6\u5c0f\u7ea2\u82b1\u5566!";
            url = this.wxPortalCustomerProperties.getOfficeWechatUrl();
        } else {
            if ("\u53d1\u5e03\u672c\u5730\u7206\u6599\u9886\u73b0\u91d1\u5956\u52b1\u54e6".equals(wxMessage.getTitle()) || "\u53bb\u53d1\u5e03".equals(wxMessage.getTitle())) {
                LOGGER.debug("\u7528\u6237\u70b9\u51fb\u53bb\u53d1\u5e16\u6309\u94ae");
                this.sendDownloadApp("\u70b9\u51fb\u94fe\u63a5\u4e0b\u8f7dApp\u53bb\u53d1\u5e03\u54e6~", "\u7acb\u5373\u4e0b\u8f7d", this.buildDownloadUrl("applet-post"), "\u70b9\u51fb\u4e0b\u65b9\u94fe\u63a5\u4e0b\u8f7d\u672c\u5730\u4e07\u4e8b\u901aApp\u53bb\u53d1\u5e03", service, wxMessage);
                return;
            }
            if ("\u4e0b\u8f7d\u9886\u7ea2\u5305".equals(wxMessage.getTitle())) {
                LOGGER.debug("\u7528\u6237\u70b9\u51fb\u4e0b\u8f7d\u9886\u7ea2\u5305\u6309\u94ae");
                this.sendDownloadApp("\u70b9\u51fb\u4e0b\u8f7dApp\u9886\u7ea2\u5305\uff01", "\u624b\u6162\u65e0\uff0c\u5feb\u62a2", this.buildDownloadUrl("applet-rp"), "\u70b9\u51fb\u4e0b\u65b9\u94fe\u63a5\u4e0b\u8f7d\u672c\u5730\u4e07\u4e8b\u901aApp\uff0c\u9a6c\u4e0a\u9886\u7ea2\u5305", service, wxMessage);
                return;
            }
        }
        LOGGER.info("content:[{}],url:[{}]", (Object)content, (Object)url);
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            WxMediaUploadResult uploadResult = service.getMediaService().uploadMedia("image", "png", this.getInputStreamByUrl(url));
            service.getMsgService().sendKefuMsg(((TextMessageBuilder)WxMaKefuMessage.newTextBuilder().content(content).toUser(wxMessage.getFromUser())).build());
            service.getMsgService().sendKefuMsg(((ImageMessageBuilder)WxMaKefuMessage.newImageBuilder().mediaId(uploadResult.getMediaId()).toUser(wxMessage.getFromUser())).build());
        }
    };

    public WxMaConfiguration(WxMaProperties properties, RedisStringAdapter redisStringAdapter, WxPortalCustomerProperties wxPortalCustomerProperties, BaseUrlFacadeService baseUrlFacadeService, CustomApacheHttpClientBuilder customApacheHttpClientBuilder) {
        this.properties = properties;
        this.redisStringAdapter = redisStringAdapter;
        this.wxPortalCustomerProperties = wxPortalCustomerProperties;
        this.baseUrlFacadeService = baseUrlFacadeService;
        this.customApacheHttpClientBuilder = customApacheHttpClientBuilder;
    }

    private String buildDownloadUrl(String source) {
        String downloadUrl = this.baseUrlFacadeService.getDownloadYYBUrl();
        downloadUrl = downloadUrl.contains("?") ? downloadUrl + "&source=" + source : downloadUrl + "?source=" + source;
        return downloadUrl;
    }

    private void sendDownloadApp(String title, String desc, String url, String content, WxMaService service, WxMaMessage wxMessage) throws WxErrorException {
        service.getMsgService().sendKefuMsg(((TextMessageBuilder)WxMaKefuMessage.newTextBuilder().content(content).toUser(wxMessage.getFromUser())).build());
        service.getMsgService().sendKefuMsg(((LinkMessageBuilder)WxMaKefuMessage.newLinkBuilder().url(url).thumbUrl(this.baseUrlFacadeService.getAppIconUrl()).title(title).description(desc).toUser(wxMessage.getFromUser())).build());
    }

    public static Map<String, WxMaMessageRouter> getRouters() {
        return routers;
    }

    public static WxMaService getMaService(String appid) {
        WxMaService wxService = maServices.get(appid);
        if (wxService == null) {
            throw new IllegalArgumentException(String.format("\u672a\u627e\u5230\u5bf9\u5e94appid=[%s]\u7684\u914d\u7f6e\uff0c\u8bf7\u6838\u5b9e\uff01", appid));
        }
        return wxService;
    }

    @PostConstruct
    public void init() {
        List<WxMaProperties.Config> configs = this.properties.getConfigs();
        if (configs == null) {
            throw new RuntimeException("\u5c0f\u7a0b\u5e8f\u8bf7\u6dfb\u52a0\u76f8\u5173\u914d\u7f6e\uff0c\u6ce8\u610f\u522b\u914d\u9519\u4e86\uff01");
        }
        maServices = configs.stream().map(config -> {
            WxMaServiceImpl service = new WxMaServiceImpl();
            service.setWxMaConfig((WxMaConfig)this.setConfig((WxMaProperties.Config)config));
            routers.put(config.getAppid(), this.newRouter((WxMaService)service));
            return service;
        }).collect(Collectors.toMap(s -> s.getWxMaConfig().getAppid(), a -> a));
    }

    private WxMaInRedisConfig setConfig(WxMaProperties.Config config) {
        WxMaInRedisConfig wxMaInRedisConfig = new WxMaInRedisConfig(this.redisStringAdapter, this.customApacheHttpClientBuilder);
        wxMaInRedisConfig.setAppid(config.getAppid());
        wxMaInRedisConfig.setSecret(config.getSecret());
        wxMaInRedisConfig.setToken(config.getToken());
        wxMaInRedisConfig.setAesKey(config.getAesKey());
        wxMaInRedisConfig.setMsgDataFormat(config.getMsgDataFormat());
        return wxMaInRedisConfig;
    }

    private WxMaMessageRouter newRouter(WxMaService service) {
        WxMaMessageRouter router = new WxMaMessageRouter(service);
        router.rule().handler(this.logHandler).next().rule().async(false).content("\u6a21\u677f").handler(this.templateMsgHandler).end().rule().async(false).content("\u6587\u672c").handler(this.textHandler).end().rule().async(false).content("\u56fe\u7247").handler(this.picHandler).end().rule().async(false).content("\u4e8c\u7ef4\u7801").handler(this.qrcodeHandler).end();
        return router;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getInputStreamByUrl(String imageUrl) {
        InputStream is = null;
        ByteArrayOutputStream os = null;
        try {
            URL url = new URL(UriUtils.encodePath((String)imageUrl, (String)"UTF-8"));
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestProperty("Content-Type", "plain/text;charset=UTF-8");
            conn.setRequestProperty("charset", "UTF-8");
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setRequestMethod("GET");
            conn.setReadTimeout(20000);
            conn.connect();
            InputStream inputStream = conn.getInputStream();
            return inputStream;
        }
        catch (IOException e) {
            LOGGER.error("\u53d1\u8d77\u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38:", (Throwable)e);
            InputStream inputStream = null;
            return inputStream;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LOGGER.error("\u3010\u5173\u95ed\u6d41\u5f02\u5e38\u3011");
                }
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    LOGGER.error("\u3010\u5173\u95ed\u6d41\u5f02\u5e38\u3011");
                }
            }
        }
    }
}

