/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.filter.general;

import com.bxm.localnews.activity.common.config.ActivityProperties;
import com.bxm.localnews.thirdparty.advert.annotation.AdverFilter;
import com.bxm.localnews.thirdparty.filter.AbstractAdvertFilterHandler;
import com.bxm.localnews.thirdparty.param.AdvertisementParam;
import com.bxm.localnews.thirdparty.vo.AdvertVO;
import com.bxm.newidea.component.tools.MD5Util;
import com.bxm.newidea.component.tools.StringUtils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.springframework.beans.factory.annotation.Autowired;

@AdverFilter
public class Taoqi365AdvertisementFilter
extends AbstractAdvertFilterHandler {
    private final ActivityProperties activityProperties;
    private static final String URL_PREFIX = "https://tq.jfshou.cn";

    @Autowired
    public Taoqi365AdvertisementFilter(ActivityProperties activityProperties) {
        this.activityProperties = activityProperties;
    }

    @Override
    protected boolean doFilter(List<AdvertVO> advertDtos, AdvertisementParam param) {
        advertDtos.forEach(item -> {
            if (StringUtils.startsWith((CharSequence)item.getAddress(), (CharSequence)URL_PREFIX)) {
                item.setAddress(this.parseUrl(item.getAddress(), param));
            }
        });
        return true;
    }

    private String parseUrl(String sourceUrl, AdvertisementParam param) {
        if (StringUtils.isBlank((CharSequence)sourceUrl)) {
            return sourceUrl;
        }
        sourceUrl = sourceUrl.contains("?") ? sourceUrl + "&" : sourceUrl + "?";
        sourceUrl = sourceUrl + "machineCode=" + param.getUserId();
        sourceUrl = sourceUrl + "&agentId=" + this.activityProperties.getTaoqi365AgentId();
        sourceUrl = sourceUrl + "&timestamp=" + System.currentTimeMillis();
        List paramList = URLEncodedUtils.parse((String)StringUtils.substring((String)sourceUrl, (int)(sourceUrl.indexOf("?") + 1)), (Charset)StandardCharsets.UTF_8);
        paramList = paramList.stream().sorted(Comparator.comparing(NameValuePair::getName)).collect(Collectors.toList());
        StringBuilder signSource = new StringBuilder();
        for (NameValuePair nameValuePair : paramList) {
            if (StringUtils.equalsAny((CharSequence)nameValuePair.getName(), (CharSequence[])this.activityProperties.getExcludeParam())) continue;
            signSource.append(nameValuePair.getName()).append("=").append(nameValuePair.getValue());
            signSource.append("&");
        }
        signSource.append("secretKey").append("=").append(this.activityProperties.getTaoqi365SecertKey());
        sourceUrl = sourceUrl + "&sign=" + MD5Util.hgmd5((String)signSource.toString()).toUpperCase();
        return sourceUrl;
    }
}

