/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.filter.impl;

import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.thirdparty.advert.annotation.AdverFilter;
import com.bxm.localnews.thirdparty.constant.AdvertTypeEnum;
import com.bxm.localnews.thirdparty.filter.AbstractAdvertFilterHandler;
import com.bxm.localnews.thirdparty.filter.AdvertFilterService;
import com.bxm.localnews.thirdparty.param.AdvertisementParam;
import com.bxm.localnews.thirdparty.vo.AdvertVO;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AdvertFilterServiceImpl
implements AdvertFilterService,
ApplicationContextAware {
    private Map<AdvertTypeEnum, List<AbstractAdvertFilterHandler>> advertisements = Maps.newHashMap();
    private List<AbstractAdvertFilterHandler> defaultFilters = Lists.newArrayList();
    @Autowired
    private UserIntegrationService userIntegrationService;

    @Override
    public void filter(List<AdvertVO> advertVOS, AdvertisementParam param) {
        List<AbstractAdvertFilterHandler> filters;
        if (CollectionUtils.isEmpty(advertVOS)) {
            return;
        }
        if (null != param.getUserId()) {
            UserInfoDTO userInfo = this.userIntegrationService.getUserFromRedisDB(param.getUserId());
            param.setUserInfo(userInfo);
        }
        if (null != this.defaultFilters) {
            for (AbstractAdvertFilterHandler defaultFilter : this.defaultFilters) {
                if (defaultFilter.filter(advertVOS, param)) continue;
                return;
            }
        }
        if (null != (filters = this.advertisements.get(AdvertTypeEnum.getByPosition((int)param.getType().byteValue())))) {
            for (AbstractAdvertFilterHandler filter : filters) {
                if (filter.filter(advertVOS, param)) continue;
                return;
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Collection filterMap = applicationContext.getBeansOfType(AbstractAdvertFilterHandler.class).values();
        filterMap.forEach(p -> {
            AdverFilter adverFilter = (AdverFilter)AnnotationUtils.getAnnotation((AnnotatedElement)AopUtils.getTargetClass((Object)p), AdverFilter.class);
            if (null != adverFilter) {
                this.addFilter(adverFilter.value(), (AbstractAdvertFilterHandler)p);
            }
        });
    }

    private void addFilter(AdvertTypeEnum[] positions, AbstractAdvertFilterHandler filter) {
        if (null == positions || positions.length == 0) {
            this.defaultFilters.add(filter);
        }
        for (AdvertTypeEnum position : positions) {
            ArrayList filters = this.advertisements.get(position);
            if (CollectionUtils.isEmpty(filters)) {
                filters = Lists.newArrayList();
                this.advertisements.put(position, filters);
            }
            filters.add(filter);
        }
    }
}

