/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.filter.position;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.dto.UserTbkInfo;
import com.bxm.localnews.integration.CommodityInfoFacadeService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.thirdparty.advert.annotation.AdverFilter;
import com.bxm.localnews.thirdparty.config.DuoMaiMeituanProperties;
import com.bxm.localnews.thirdparty.dto.MeituanEuid;
import com.bxm.localnews.thirdparty.filter.AbstractAdvertFilterHandler;
import com.bxm.localnews.thirdparty.param.AdvertisementParam;
import com.bxm.localnews.thirdparty.vo.AdvertVO;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@AdverFilter
public class ConvertAdverFilter
extends AbstractAdvertFilterHandler {
    private static final Logger log = LoggerFactory.getLogger(ConvertAdverFilter.class);
    @Autowired
    private UserIntegrationService userIntegrationService;
    @Autowired
    private CommodityInfoFacadeService commodityInfoFacadeService;
    @Autowired
    private DuoMaiMeituanProperties duoMaiMeituanProperties;

    @Override
    protected boolean doFilter(List<AdvertVO> advertVOS, AdvertisementParam param) {
        this.attach(param, advertVOS);
        return true;
    }

    private void attach(AdvertisementParam param, List<AdvertVO> advertDtos) {
        if (Objects.isNull(param.getUserId())) {
            return;
        }
        advertDtos.forEach(p -> {
            if (Objects.nonNull(p) && Objects.nonNull(p.getFollowAct()) && p.getFollowAct() == 3 && StringUtils.isNotBlank((String)p.getAdzoneId()) && StringUtils.isNotBlank((String)p.getFollowContent())) {
                String taoBaoUnionUrl;
                UserTbkInfo tbkInfo = this.userIntegrationService.selectUserFromCacheByUserId(param.getUserId());
                if (Objects.isNull(tbkInfo) || StringUtils.isBlank((String)tbkInfo.getTbkRelationId())) {
                    return;
                }
                Long adzoneId = null;
                Long promotionSceneId = null;
                try {
                    adzoneId = Long.valueOf(p.getAdzoneId());
                    promotionSceneId = Long.parseLong(p.getFollowContent());
                }
                catch (Exception e) {
                    log.warn("\u7c7b\u578b\u8f6c\u6362\u5931\u8d25\uff0cmaterialId: {} \u7684\u5e7f\u544a\u4f4d\u914d\u7f6e\u6709\u95ee\u9898 \u65e0\u6cd5\u8f6c\u6362\u6dd8\u5b9d\u8054\u76df\u6d3b\u52a8", (Object)p.getMaterialId());
                }
                if (Objects.nonNull(adzoneId) && Objects.nonNull(promotionSceneId) && StringUtils.isNotBlank((String)(taoBaoUnionUrl = this.commodityInfoFacadeService.getTaoBaoUnion(adzoneId, tbkInfo.getTbkRelationId(), promotionSceneId)))) {
                    if (taoBaoUnionUrl.contains("https")) {
                        p.setAddress(StringUtils.isNotBlank((String)taoBaoUnionUrl) ? taoBaoUnionUrl.replaceAll("https", "wst://function/openApp?url=tbopen") : "");
                    } else {
                        p.setAddress(StringUtils.isNotBlank((String)taoBaoUnionUrl) ? taoBaoUnionUrl.replaceAll("http", "wst://function/openApp?url=tbopen") : "");
                    }
                }
            }
        });
    }

    private String meituanJumpUrl(Long userId) {
        MeituanEuid euid = new MeituanEuid();
        euid.setUserId(userId);
        euid.setTime(new Date());
        euid.setSiteId("LOCAL_NEWS");
        try {
            URIBuilder uriBuilder = new URIBuilder(this.duoMaiMeituanProperties.getTrackUrl());
            uriBuilder.addParameter("site_id", this.duoMaiMeituanProperties.getSiteId());
            uriBuilder.addParameter("aid", this.duoMaiMeituanProperties.getAid());
            uriBuilder.addParameter("euid", JSON.toJSONString((Object)euid));
            uriBuilder.addParameter("t", this.duoMaiMeituanProperties.getTargetUrl());
            return uriBuilder.build().toString();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "";
        }
    }
}

