/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.filter.position;

import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.thirdparty.advert.annotation.AdverFilter;
import com.bxm.localnews.thirdparty.constant.AdvertTypeEnum;
import com.bxm.localnews.thirdparty.filter.AbstractAdvertFilterHandler;
import com.bxm.localnews.thirdparty.param.AdvertisementParam;
import com.bxm.localnews.thirdparty.vo.AdvertVO;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

@AdverFilter(value={AdvertTypeEnum.INDEX_POP_WINDOW})
public class IndexPopWindowFilter
extends AbstractAdvertFilterHandler {
    @Autowired
    RedisStringAdapter redisStringAdapter;
    @Autowired
    UserIntegrationService userIntegrationService;

    @Override
    protected boolean doFilter(List<AdvertVO> advertVOS, AdvertisementParam param) {
        UserInfoDTO userInfoDTO;
        String registerChannel = null;
        if (null != param.getUserId() && null != (userInfoDTO = param.loadCacheUserInfo())) {
            registerChannel = userInfoDTO.getRegisterChannel();
        }
        advertVOS.removeIf(advertDTO -> super.checkRemoveAdvertInfo(param.getUserId(), advertDTO.getId(), advertDTO.getShowType()));
        if (advertVOS.size() > 0) {
            String finalRegisterChannel = registerChannel;
            advertVOS.removeIf(advertDTO -> !this.checkAdvertDeliveryObject(finalRegisterChannel, advertDTO.getDeliveryObject()));
        }
        return true;
    }

    private boolean checkAdvertDeliveryObject(String registerChannel, String deliveryObject) {
        if (StringUtils.isEmpty((CharSequence)deliveryObject) || InviteTypeEnum.ALL.getName().equals(deliveryObject)) {
            return true;
        }
        return StringUtils.isNotEmpty((CharSequence)registerChannel) && registerChannel.equals(deliveryObject);
    }
}

