/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.filter.position;

import com.bxm.localnews.base.service.LocationFacadeService;
import com.bxm.localnews.common.dto.LocationDetailDTO;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.thirdparty.advert.annotation.AdverFilter;
import com.bxm.localnews.thirdparty.constant.AdvertTypeEnum;
import com.bxm.localnews.thirdparty.filter.AbstractAdvertFilterHandler;
import com.bxm.localnews.thirdparty.param.AdvertisementParam;
import com.bxm.localnews.thirdparty.vo.AdvertVO;
import com.bxm.newidea.component.tools.StringUtils;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AdverFilter(value={AdvertTypeEnum.H5_MY_PAGE, AdvertTypeEnum.H5_GOODS_INFO, AdvertTypeEnum.H5_MEMBER_DAY_MALL})
public class PartnerPositionAdverFilter
extends AbstractAdvertFilterHandler {
    private static final Logger log = LoggerFactory.getLogger(PartnerPositionAdverFilter.class);
    private final UserIntegrationService userIntegrationService;
    private final LocationFacadeService locationFacadeService;

    @Override
    protected boolean doFilter(List<AdvertVO> advertVOS, AdvertisementParam param) {
        UserInfoDTO userInfo = param.getUserInfo();
        if (Objects.isNull(userInfo)) {
            UserInfoDTO userFromRedisDB = this.userIntegrationService.getUserFromRedisDB(param.getUserId());
            param.setUserInfo(userFromRedisDB);
            userInfo = userFromRedisDB;
        }
        UserInfoDTO finalUserInfo = userInfo;
        advertVOS.forEach(advertVO -> {
            boolean talent = finalUserInfo.getTalentLevel() != null && !Objects.equals(finalUserInfo.getTalentLevel(), 0);
            advertVO.setAddress(this.talentUrl(advertVO.getAddress(), talent ? 1 : 0, param.getAreaCode(), param.getUserId()));
        });
        return false;
    }

    private String talentUrl(String address, Integer isTalent, String areaCode, Long userId) {
        LocationDetailDTO locationDetailByCode = this.locationFacadeService.getLocationDetailByCode(areaCode);
        String areaName = "\u672c\u5730";
        if (Objects.nonNull(locationDetailByCode)) {
            areaName = locationDetailByCode.getName();
        }
        if (StringUtils.isBlank((CharSequence)address)) {
            return address;
        }
        StringBuilder str = new StringBuilder();
        if (address.contains("?")) {
            str.append(address).append("&isTalent=").append(isTalent).append("&areaName=").append(areaName).append("&areaCode=").append(areaCode).append("&userId=").append(userId);
        } else {
            str.append(address).append("?isTalent=").append(isTalent).append("&areaName=").append(areaName).append("&areaCode=").append(areaCode).append("&userId=").append(userId);
        }
        return str.toString();
    }

    public PartnerPositionAdverFilter(UserIntegrationService userIntegrationService, LocationFacadeService locationFacadeService) {
        this.userIntegrationService = userIntegrationService;
        this.locationFacadeService = locationFacadeService;
    }
}

