/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.filter.position;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.thirdparty.advert.annotation.AdverFilter;
import com.bxm.localnews.thirdparty.filter.AbstractAdvertFilterHandler;
import com.bxm.localnews.thirdparty.param.AdvertisementParam;
import com.bxm.localnews.thirdparty.vo.AdvertVO;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AdverFilter
public class PhoneReplaceAdvertFilter
extends AbstractAdvertFilterHandler {
    private static final Logger log = LoggerFactory.getLogger(PhoneReplaceAdvertFilter.class);

    @Override
    protected boolean doFilter(List<AdvertVO> advertVOS, AdvertisementParam param) {
        for (AdvertVO advertVO : advertVOS) {
            String address = advertVO.getAddress();
            if (!StringUtils.contains((CharSequence)address, (CharSequence)"{phone}")) continue;
            UserInfoDTO userInfo = param.loadCacheUserInfo();
            if (StringUtils.isBlank((CharSequence)userInfo.getPhone())) {
                log.info("\u7528\u6237[{}]\u4e0d\u5b58\u5728\u624b\u673a\u53f7\u7801,\u7528\u6237\u4fe1\u606f\u4e3a\uff1a{}", (Object)param.getUserId(), (Object)JSON.toJSONString((Object)userInfo));
                continue;
            }
            advertVO.setAddress(StringUtils.replace((String)address, (String)"{phone}", (String)userInfo.getPhone()));
            if (!StringUtils.isNotBlank((CharSequence)advertVO.getFollowContent())) continue;
            advertVO.setFollowContent(StringUtils.replace((String)advertVO.getFollowContent(), (String)"{phone}", (String)userInfo.getPhone()));
        }
        return true;
    }
}

