/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.filter.position;

import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.thirdparty.advert.annotation.AdverFilter;
import com.bxm.localnews.thirdparty.config.KfcProperty;
import com.bxm.localnews.thirdparty.constant.AdverFollowAct;
import com.bxm.localnews.thirdparty.filter.AbstractAdvertFilterHandler;
import com.bxm.localnews.thirdparty.param.AdvertisementParam;
import com.bxm.localnews.thirdparty.util.SignUtils;
import com.bxm.localnews.thirdparty.util.UrlParamsUtils;
import com.bxm.localnews.thirdparty.vo.AdvertVO;
import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@AdverFilter
public class QianZhuAdverFilter
extends AbstractAdvertFilterHandler {
    private static final Logger log = LoggerFactory.getLogger(QianZhuAdverFilter.class);
    @Autowired
    private KfcProperty kfcProperty;
    private static final String WEB_PROTOCOL = "wst://web/webDetail?url=";

    @Override
    protected boolean doFilter(List<AdvertVO> advertVOS, AdvertisementParam param) {
        this.attach(param, advertVOS);
        return true;
    }

    private void attach(AdvertisementParam param, List<AdvertVO> advertDtos) {
        if (Objects.isNull(param.getUserId())) {
            return;
        }
        advertDtos.forEach(p -> {
            if (Objects.nonNull(p) && Objects.nonNull(p.getFollowAct()) && p.getFollowAct().intValue() == AdverFollowAct.QIANZHU_KFC.getFollowAct()) {
                UserInfoDTO userInfoDTO = param.loadCacheUserInfo();
                String nickName = Objects.isNull(userInfoDTO) ? "" : userInfoDTO.getNickname();
                try {
                    HashMap signMap = Maps.newHashMap();
                    signMap.put("platformUniqueId", param.getUserId());
                    signMap.put("nickname", nickName);
                    signMap.put("platformId", this.kfcProperty.getPlatformId());
                    signMap.put("timestamp", System.currentTimeMillis());
                    signMap.put("redirectUrl", "");
                    String sign = SignUtils.generateSign(signMap, this.kfcProperty.getSecret());
                    signMap.put("sign", sign);
                    String paramStr = UrlParamsUtils.toParams(signMap);
                    String url = URLEncoder.encode(StringUtils.join((Object[])new String[]{this.kfcProperty.getServerUrl(), "/api/v2/platform/login?", paramStr}), Charsets.UTF_8.name());
                    url = url.replace("+", "%20");
                    p.setAddress(WEB_PROTOCOL + url);
                }
                catch (Exception e) {
                    log.error("\u83b7\u53d6\u5343\u732a\u80af\u5fb7\u57fa\u70b9\u9910\u5730\u5740\u5931\u8d25", (Throwable)e);
                }
            }
        });
    }
}

