/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.filter.position;

import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.thirdparty.advert.annotation.AdverFilter;
import com.bxm.localnews.thirdparty.constant.AdvertTypeEnum;
import com.bxm.localnews.thirdparty.filter.AbstractAdvertFilterHandler;
import com.bxm.localnews.thirdparty.param.AdvertisementParam;
import com.bxm.localnews.thirdparty.vo.AdvertVO;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@AdverFilter(value={AdvertTypeEnum.START_SCREEN})
public class StartScreenAdverFilter
extends AbstractAdvertFilterHandler {
    private static final Logger log = LoggerFactory.getLogger(StartScreenAdverFilter.class);
    @Autowired
    RedisStringAdapter redisStringAdapter;
    @Autowired
    UserIntegrationService userIntegrationService;

    @Override
    protected boolean doFilter(List<AdvertVO> advertVOS, AdvertisementParam param) {
        if (!CollectionUtils.isEmpty(advertVOS) && advertVOS.size() > 1) {
            int index = RandomUtils.nextInt((int)0, (int)advertVOS.size());
            if (log.isDebugEnabled()) {
                log.debug("\u5f00\u5c4f\u5e7f\u544a\u6709: {}\u4e2a\uff0c\u968f\u673a\u9009\u7528\u89d2\u6807: {}\u7684\u5e78\u8fd0\u513f\u5c55\u793a", (Object)advertVOS.size(), (Object)index);
            }
            AdvertVO adv = advertVOS.get(index);
            advertVOS.removeIf(p -> !Objects.equals(p.getMaterialId(), adv.getMaterialId()));
        }
        return true;
    }
}

