/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.filter.position.topShowcaseStrategy;

import com.bxm.localnews.base.service.BaseUrlFacadeService;
import com.bxm.localnews.dto.PoolCommodityListItem;
import com.bxm.localnews.integration.CommodityInfoFacadeService;
import com.bxm.localnews.thirdparty.config.AdverProperties;
import com.bxm.localnews.thirdparty.enums.FollowActEnum;
import com.bxm.localnews.thirdparty.filter.position.topShowcaseStrategy.TopShowcaseStrategy;
import com.bxm.localnews.thirdparty.param.AdvertisementParam;
import com.bxm.localnews.thirdparty.vo.AdvertVO;
import com.bxm.localnews.thirdparty.vo.ZeroCommodityAdver;
import com.bxm.newidea.component.vo.BasicParam;
import com.bxm.newidea.component.vo.PageParam;
import com.gexin.fastjson.JSON;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ZeroBuyStrategy
extends TopShowcaseStrategy {
    private static final Logger log = LoggerFactory.getLogger(ZeroBuyStrategy.class);
    private final CommodityInfoFacadeService commodityInfoFacadeService;
    private final AdverProperties adverProperties;
    private final BaseUrlFacadeService baseUrlFacadeService;

    @Override
    public Boolean removeInfo(AdvertVO advertVO, AdvertisementParam param) {
        PoolCommodityListItem commodityExtData = this.getCommodityExtData(param, this.adverProperties.getNovicePoolId());
        if (!Objects.nonNull(commodityExtData)) {
            if (log.isDebugEnabled()) {
                log.debug("\u83b7\u53d6\u65b0\u4eba\u5546\u54c1\u5931\u8d25\uff0c\u79fb\u9664\u5e7f\u544a");
            }
            return true;
        }
        ZeroCommodityAdver zeroCommodityAdver = this.convert(commodityExtData);
        advertVO.setExtData((Object)zeroCommodityAdver);
        String jumpUrl = this.baseUrlFacadeService.getInnerH5BaseUrl() + this.adverProperties.getNoviceCommodityUrl();
        zeroCommodityAdver.setJumpUrl(jumpUrl);
        advertVO.setAddress(jumpUrl);
        return false;
    }

    @Override
    public Integer getType() {
        return FollowActEnum.JUMP_ZERO_BUY.getType();
    }

    private PoolCommodityListItem getCommodityExtData(AdvertisementParam param, Long poolId) {
        PageParam pageParam = new PageParam();
        pageParam.setPageNum(Integer.valueOf(1));
        pageParam.setPageSize(Integer.valueOf(3));
        List commodityPoolCommodities = this.commodityInfoFacadeService.getCommodityPoolCommodities((BasicParam)param, pageParam, poolId, param.getUserId());
        if (log.isDebugEnabled()) {
            log.debug("\u67e5\u8be2\u5546\u54c1\u6570\u636e\uff0cparam: {}, poolId: {}, result: {}", new Object[]{JSON.toJSONString((Object)param), poolId, JSON.toJSONString((Object)commodityPoolCommodities)});
        }
        if (!CollectionUtils.isEmpty((Collection)commodityPoolCommodities)) {
            return (PoolCommodityListItem)commodityPoolCommodities.get(0);
        }
        return null;
    }

    private ZeroCommodityAdver convert(PoolCommodityListItem commodityExtData) {
        ZeroCommodityAdver zeroCommodityAdver = new ZeroCommodityAdver();
        if (Objects.nonNull(commodityExtData.getCommodityPrice())) {
            try {
                String price = BigDecimal.valueOf(commodityExtData.getCommodityPrice()).stripTrailingZeros().toPlainString();
                zeroCommodityAdver.setPrice(new BigDecimal(price));
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u7ea2\u82b1\u593a\u5b9d\u6d3b\u52a8\u5546\u54c1\u4ef7\u683c\u8f6c\u6362\u9519\u8bef: [{}],\u9519\u8bef\u4fe1\u606f", (Object)commodityExtData, (Object)e);
            }
        }
        zeroCommodityAdver.setImg(commodityExtData.getImgUrl());
        return zeroCommodityAdver;
    }

    public ZeroBuyStrategy(CommodityInfoFacadeService commodityInfoFacadeService, AdverProperties adverProperties, BaseUrlFacadeService baseUrlFacadeService) {
        this.commodityInfoFacadeService = commodityInfoFacadeService;
        this.adverProperties = adverProperties;
        this.baseUrlFacadeService = baseUrlFacadeService;
    }
}

