/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.activity.common.config.AdvertProperties;
import com.bxm.localnews.base.service.AppVersionSupplyService;
import com.bxm.localnews.base.service.AreaWhiteBlackService;
import com.bxm.localnews.base.service.LocationFacadeService;
import com.bxm.localnews.common.constant.AreaWhiteBlackKeyEnum;
import com.bxm.localnews.common.dto.AppVersionDTO;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.thirdparty.constant.AdvertTypeEnum;
import com.bxm.localnews.thirdparty.domain.AdvertAreaMapper;
import com.bxm.localnews.thirdparty.domain.AdvertMapper;
import com.bxm.localnews.thirdparty.domain.AdvertPositionMapper;
import com.bxm.localnews.thirdparty.dto.AdvertDTO;
import com.bxm.localnews.thirdparty.dto.ClassificationDTO;
import com.bxm.localnews.thirdparty.dto.HomeWindowDTO;
import com.bxm.localnews.thirdparty.filter.AdvertFilterService;
import com.bxm.localnews.thirdparty.param.AdvertParam;
import com.bxm.localnews.thirdparty.param.AdvertisementParam;
import com.bxm.localnews.thirdparty.param.HomeWindowParam;
import com.bxm.localnews.thirdparty.service.AdvertService;
import com.bxm.localnews.thirdparty.vo.Advert;
import com.bxm.localnews.thirdparty.vo.AdvertArea;
import com.bxm.localnews.thirdparty.vo.AdvertRecord;
import com.bxm.localnews.thirdparty.vo.AdvertVO;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.MD5Util;
import com.bxm.newidea.component.vo.BasicParam;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdvertServiceImpl
implements AdvertService {
    private static final Logger LOG = LoggerFactory.getLogger(AdvertServiceImpl.class);
    private AdvertMapper advertMapper;
    private AdvertAreaMapper advertAreaMapper;
    private RedisStringAdapter redisStringAdapter;
    private LocationFacadeService locationFacadeService;
    private AdvertPositionMapper advertPositionMapper;
    private UserIntegrationService userIntegrationService;
    private AppVersionSupplyService appVersionSupplyService;
    @Autowired
    private AdvertFilterService advertFilterService;
    @Autowired
    private AdvertProperties adverProperties;
    private AreaWhiteBlackService areaWhiteBlackService;
    private static String DEFAULT_AREACODE = "0";

    public AdvertServiceImpl(AdvertMapper advertMapper, AdvertAreaMapper advertAreaMapper, RedisStringAdapter redisStringAdapter, LocationFacadeService locationFacadeService, AdvertPositionMapper advertPositionMapper, UserIntegrationService userIntegrationService, AppVersionSupplyService appVersionSupplyService, AreaWhiteBlackService areaWhiteBlackService) {
        this.advertMapper = advertMapper;
        this.advertAreaMapper = advertAreaMapper;
        this.redisStringAdapter = redisStringAdapter;
        this.locationFacadeService = locationFacadeService;
        this.advertPositionMapper = advertPositionMapper;
        this.userIntegrationService = userIntegrationService;
        this.appVersionSupplyService = appVersionSupplyService;
        this.areaWhiteBlackService = areaWhiteBlackService;
    }

    public List<AdvertVO> queryAdByType(Byte type, String areaCode, Long userId, com.bxm.localnews.common.vo.BasicParam basicParam) {
        AdvertisementParam param = new AdvertisementParam();
        if (null != basicParam) {
            param.merge((BasicParam)basicParam);
        }
        param.setUserId(userId);
        param.setType(type);
        param.setAreaCode(areaCode);
        return this.queryAdByType(param);
    }

    public List<AdvertVO> queryAdByType(AdvertisementParam param) {
        List<AdvertDTO> advertList = this.loadCacheInfo(param);
        List<AdvertVO> advertVOS = advertList.stream().map(this::convert).collect(Collectors.toList());
        this.advertFilterService.filter(advertVOS, param);
        if (param.getUserId() != null && CollectionUtils.isNotEmpty(advertList)) {
            this.recordAdvert(param.getUserId(), advertList);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("\u6839\u636e\u5730\u533a{}\u83b7\u53d6\u5f97\u5230\u7684\u5e7f\u544a\u5217\u8868\u4fe1\u606f\u4e3a:{}", (Object)(StringUtils.isBlank((CharSequence)param.getAreaCode()) ? "0" : param.getAreaCode()), (Object)JSON.toJSONString(advertVOS));
        }
        return advertVOS;
    }

    private List<AdvertDTO> loadCacheInfo(AdvertisementParam param) {
        String key;
        List advertList;
        Byte type = param.getType();
        String areaCode = param.getAreaCode();
        Long userId = param.getUserId();
        Long positionBizId = param.getPositionBizId();
        if (LOG.isDebugEnabled()) {
            LOG.debug("\u8bf7\u6c42\u5e7f\u544a\u63a5\u53e3,\u53c2\u6570,type:[{}],positionBizId:[{}]areaCode:[{}],userId:[{}],basicParam:[{}]", new Object[]{type, positionBizId, areaCode, userId, param});
        }
        if (StringUtils.isBlank((CharSequence)areaCode)) {
            areaCode = DEFAULT_AREACODE;
        }
        if (CollectionUtils.isEmpty((Collection)(advertList = this.areaWhiteBlackService.getCacheByAreaCode(key = StringUtils.join((Object[])new Serializable[]{AreaWhiteBlackKeyEnum.ADVERT.getKey(), type}), areaCode, (TypeReference)new TypeReference<List<AdvertDTO>>(){})))) {
            advertList = this.advertPositionMapper.getAdvertPositionListByType(Integer.valueOf(type.byteValue()), null, Integer.valueOf(1));
            if (!DEFAULT_AREACODE.equals(areaCode)) {
                List<Long> whiteAreaList = this.getAdvertArea(areaCode, 1);
                List<Long> blackAreaList = this.getAdvertArea(areaCode, 2);
                advertList = this.areaWhiteBlackService.filterCacheByAreaCode(advertList, whiteAreaList, blackAreaList);
            }
            this.areaWhiteBlackService.setCacheByAreaCode(key, areaCode, advertList);
        }
        advertList = advertList.stream().filter(this::removeByPutTime).filter(p -> {
            if (Objects.nonNull(param.getPositionBizId())) {
                return Objects.equals(p.getPositionBizId(), param.getPositionBizId());
            }
            return p.getPositionBizId() == null || Objects.equals(p.getPositionBizId(), 0L);
        }).collect(Collectors.toList());
        return advertList;
    }

    public List<AdvertVO> queryAdByTypeIds(AdvertisementParam param) {
        if (StringUtils.isBlank((CharSequence)param.getIds())) {
            return Collections.emptyList();
        }
        List<AdvertDTO> advertList = this.loadCacheInfoByIds(param);
        List<AdvertVO> advertVOS = advertList.stream().map(this::convert).collect(Collectors.toList());
        this.advertFilterService.filter(advertVOS, param);
        if (param.getUserId() == null || CollectionUtils.isNotEmpty(advertList)) {
            // empty if block
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("\u6839\u636e\u5730\u533a{}\u83b7\u53d6\u5f97\u5230\u7684\u5de5\u5177\u5217\u8868\u4fe1\u606f\u4e3a:{}", (Object)(StringUtils.isBlank((CharSequence)param.getAreaCode()) ? "0" : param.getAreaCode()), (Object)JSON.toJSONString(advertVOS));
        }
        return advertVOS;
    }

    private List<AdvertDTO> loadCacheInfoByIds(AdvertisementParam param) {
        List advertList;
        Byte type = param.getType();
        String areaCode = param.getAreaCode();
        Long userId = param.getUserId();
        List ids = null;
        String key = AreaWhiteBlackKeyEnum.ADVERT_IDS.getKey() + type;
        if (com.bxm.newidea.component.tools.StringUtils.isNotEmpty((CharSequence)param.getIds())) {
            ids = Arrays.asList(param.getIds().split(",")).stream().map(id -> Long.parseLong(id)).collect(Collectors.toList());
            key = key + MD5Util.encode((String)param.getIds());
        }
        LOG.info("\u8bf7\u6c42\u5e7f\u544a\u63a5\u53e3,\u53c2\u6570,type:[{}],areaCode:[{}],userId:[{}],basicParam:[{}],ids[{}]", new Object[]{type, areaCode, userId, param, ids});
        if (StringUtils.isBlank((CharSequence)areaCode)) {
            areaCode = DEFAULT_AREACODE;
        }
        if (CollectionUtils.isEmpty((Collection)(advertList = this.areaWhiteBlackService.getCacheByAreaCode(key, areaCode, (TypeReference)new TypeReference<List<AdvertDTO>>(){})))) {
            advertList = this.advertPositionMapper.getAdvertPositionListByIds(Integer.valueOf(type.byteValue()), Integer.valueOf(1), ids);
            if (!DEFAULT_AREACODE.equals(areaCode)) {
                List<Long> whiteAreaList = this.getAdvertArea(areaCode, 1);
                List<Long> blackAreaList = this.getAdvertArea(areaCode, 2);
                advertList = this.areaWhiteBlackService.filterCacheByAreaCode(advertList, whiteAreaList, blackAreaList);
            }
            this.areaWhiteBlackService.setCacheByAreaCode(AreaWhiteBlackKeyEnum.ADVERT_IDS.getKey() + type, areaCode, advertList);
        }
        advertList = advertList.stream().filter(this::removeByPutTime).collect(Collectors.toList());
        return advertList;
    }

    private AdvertVO convert(AdvertDTO advertDTO) {
        AdvertVO advertVO = new AdvertVO();
        BeanUtils.copyProperties((Object)advertDTO, (Object)advertVO);
        List<Object> preconditions = Lists.newArrayList();
        if (com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)advertDTO.getPreconditions())) {
            preconditions = Arrays.stream(advertDTO.getPreconditions().split(",")).map(Integer::parseInt).collect(Collectors.toList());
        }
        advertVO.setPreconditions((List)preconditions);
        JSONObject extData = null;
        try {
            extData = JSONObject.parseObject((String)advertDTO.getExtraData());
        }
        catch (Exception e) {
            LOG.error("\u5e7f\u544a\u7c7b\u578b\u6269\u5c55\u5b57\u6bb5: {},\u8f6c\u6362\u9519\u8bef\uff1a", (Object)advertDTO.getExtraData(), (Object)e);
        }
        advertVO.setExtData((Object)extData);
        return advertVO;
    }

    private boolean checkIsFlashbackVersion(com.bxm.localnews.common.vo.BasicParam basicParam, int type) {
        return null != basicParam && this.appVersionSupplyService.isHighVersion(basicParam.getCurVer(), "3.0.0") != 1 && 1 == basicParam.getPlatform() && (AdvertTypeEnum.INDEX_POP_WINDOW.getType() == type || AdvertTypeEnum.TURN_AROUND_ADVERT.getType() == type);
    }

    private List<AdvertDTO> getTempAdvert(Byte type, com.bxm.localnews.common.vo.BasicParam basicParam) {
        AppVersionDTO appVersionDTO = this.appVersionSupplyService.getAppVersion(basicParam, null);
        if (null != appVersionDTO && com.bxm.newidea.component.tools.StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{appVersionDTO.getDownloadLink()})) {
            AdvertDTO advert = new AdvertDTO();
            if (AdvertTypeEnum.INDEX_POP_WINDOW.getType() == type.byteValue()) {
                advert.setImgUrl("https://m.wstong.com/localnews_prod/png/20190726/1V966V81DXI7O1J60XAP9C34PEOT212NHXJYJF4.png?x-oss-process=style/scompress");
            } else if (AdvertTypeEnum.TURN_AROUND_ADVERT.getType() == type.byteValue()) {
                advert.setImgUrl("https://m.wstong.com/localnews_prod/jpg/20190726/1V966V81DXI7O1J60XAP9C34PEOT2032IXJYJG4.jpg?x-oss-process=style/scompress");
            }
            advert.setAddress(appVersionDTO.getDownloadLink());
            advert.setGlobalFlag(Byte.valueOf((byte)1));
            advert.setTitle("\u5347\u7ea7");
            advert.setId(Long.valueOf(10086L));
            advert.setStartTime(new Date(System.currentTimeMillis() - 1000L));
            advert.setEndTime(new Date(System.currentTimeMillis() + 1000L));
            advert.setShowType(Byte.valueOf((byte)0));
            return Lists.newArrayList((Object[])new AdvertDTO[]{advert});
        }
        return new ArrayList<AdvertDTO>();
    }

    private Boolean removeByPutTime(AdvertDTO advertDTO) {
        Date now = new Date();
        return !(advertDTO.getStartTime() != null && DateUtils.after((Date)advertDTO.getStartTime(), (Date)now) || advertDTO.getEndTime() != null && DateUtils.before((Date)advertDTO.getEndTime(), (Date)now));
    }

    private void recordAdvert(Long userId, List<AdvertDTO> advertDTOList) {
        ArrayList advertRecords = Lists.newArrayList();
        Date now = new Date();
        advertDTOList.forEach(advertDTO -> {
            AdvertRecord advertRecord = new AdvertRecord();
            advertRecord.setAdvertId(advertDTO.getId());
            advertRecord.setUserId(userId);
            advertRecord.setViewTime(now);
            advertRecords.add(advertRecord);
        });
        if (CollectionUtils.isEmpty((Collection)advertRecords)) {
            return;
        }
        this.advertMapper.recordAdvert((List)advertRecords);
    }

    public Advert selectByPrimaryKey(Long id) {
        return this.advertMapper.selectByPrimaryKey(id);
    }

    public List<AdvertDTO> getListAds(int size) {
        return this.advertMapper.getListAds(Integer.valueOf(size));
    }

    private List<Long> getAdvertArea(String areaCode, Integer areaType) {
        areaCode = this.locationFacadeService.completeAreaCode(areaCode);
        return this.advertAreaMapper.getAllAdvertAreaByAreaCodeAndType(areaCode, areaType).stream().map(AdvertArea::getAdvertId).collect(Collectors.toList());
    }

    public HomeWindowDTO getHomeWindow(HomeWindowParam homeWindowParam, String ip) {
        return new HomeWindowDTO();
    }

    public List<ClassificationDTO> vipPageClassificationList(AdvertParam param) {
        List classificationDTOList = JSONObject.parseArray((String)this.adverProperties.getClassification(), ClassificationDTO.class);
        AdvertisementParam advertisementParam = new AdvertisementParam();
        BeanUtils.copyProperties((Object)param, (Object)advertisementParam);
        return ((Stream)classificationDTOList.stream().parallel()).map(e -> {
            advertisementParam.setType(e.getId());
            ClassificationDTO classificationDTO = new ClassificationDTO();
            BeanUtils.copyProperties((Object)e, (Object)classificationDTO);
            List<AdvertVO> advertDtoList = this.queryAdByType(advertisementParam);
            classificationDTO.setAdvertVOList(advertDtoList);
            return classificationDTO;
        }).collect(Collectors.toList());
    }

    public AdvertVO getByMateriaId(Long id) {
        return this.advertMapper.getByMateriaId(id);
    }
}

