/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.localnews.thirdparty.service.CrmSendMessageService;
import com.bxm.localnews.thirdparty.service.WechatService;
import com.bxm.localnews.thirdparty.wxmessage.Message;
import com.bxm.localnews.thirdparty.wxmessage.UploadImg;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class CrmSendMessageServiceImpl
implements CrmSendMessageService {
    private static final Logger LOG = LoggerFactory.getLogger(CrmSendMessageServiceImpl.class);
    private static final String SERVICE_HOST = "https://api.weixin.qq.com";
    private static final int MAX_SEND_IMG_COUNT = 30;
    private static int sendImgCount = 0;
    @Autowired
    private WechatService wechatService;
    @Autowired
    private HttpClientService httpClientService;

    @Override
    @Async
    public void sendMessageOfImg(String accessToken, Message message, String uploadImagePath) {
        String url = "https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token=" + accessToken;
        String responseStr = this.httpClientService.doPost(url, JSON.toJSONString((Object)message));
        if ("image".equals(message.getMsgtype())) {
            JSONObject result = JSON.parseObject((String)responseStr);
            LOG.info("sendMessageOfImg responseStr:{}", (Object)responseStr);
            if (sendImgCount == 30 || "-1".equals(result.getString("errcode")) || "40007".equals(result.getString("errcode"))) {
                sendImgCount = 0;
                if (uploadImagePath == null) {
                    return;
                }
                LOG.info("mediaIdOld=" + message.getImage().getMedia_id() + ",uploadImagePath=" + uploadImagePath);
                String weChatToken = this.wechatService.getWeChatToken();
                String mediaIdNew = UploadImg.uploadImg((String)weChatToken, (File)new File(uploadImagePath));
                if (mediaIdNew != null) {
                    message.getImage().setMedia_id(mediaIdNew);
                    responseStr = this.httpClientService.doPost(url, JSON.toJSONString((Object)message));
                    LOG.info("reSendMessageOfImg responseStr:{}", (Object)responseStr);
                }
            } else if ("40001".equals(result.getString("errcode")) || "45047".equals(result.getString("errcode"))) {
                this.wechatService.emptyWeChatToken();
                accessToken = this.wechatService.getWeChatToken();
                this.sendMessageOfImg(accessToken, message, uploadImagePath);
            } else {
                ++sendImgCount;
            }
        }
    }

    @Override
    @Async
    public void sendMessageOfText(String accessToken, Message message) {
        String url = "https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token=" + accessToken;
        String responseStr = this.httpClientService.doPost(url, JSON.toJSONString((Object)message));
        JSONObject result = JSON.parseObject((String)responseStr);
        if ("40001".equals(result.getString("errcode")) || "45047".equals(result.getString("errcode")) || "-1".equals(result.getString("errcode"))) {
            this.wechatService.emptyWeChatToken();
            accessToken = this.wechatService.getWeChatToken();
            this.sendMessageOfText(accessToken, message);
        }
        LOG.info("sendMessageOfText:{}, responseStr:{}", (Object)message.getText().getContent(), (Object)responseStr);
    }
}

