/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.service.impl;

import com.bxm.localnews.base.service.AppVersionSupplyService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.thirdparty.dto.HomeWindowDTO;
import com.bxm.localnews.thirdparty.param.HomeWindowParam;
import com.bxm.localnews.thirdparty.service.PopService;
import com.bxm.localnews.thirdparty.service.pop.PopFactory;
import com.bxm.localnews.thirdparty.service.pop.PopTypeEnum;
import com.bxm.localnews.thirdparty.service.pop.popinstance.PopCache;
import com.bxm.localnews.thirdparty.service.pop.popinstance.PopContext;
import com.bxm.localnews.thirdparty.service.pop.popstrategy.impl.PopOnceStrategy;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PopServiceImpl
implements PopService {
    private static final Logger log = LoggerFactory.getLogger(PopServiceImpl.class);
    @Autowired
    private UserIntegrationService userIntegrationService;
    @Autowired
    private AppVersionSupplyService appVersionSupplyService;
    @Autowired
    private PopFactory popFactory;
    @Autowired
    private PopOnceStrategy popOnceStrategy;

    public HomeWindowDTO getHomeWindow(HomeWindowParam homeWindowParam) {
        if (this.appVersionSupplyService.isHighVersion(homeWindowParam.getCurVer(), "2.6.0") != -1) {
            this.userIntegrationService.sendSystemMessage(homeWindowParam.getUserId());
        }
        return this.popFactory.process(homeWindowParam);
    }

    public void addPrivacyPopCache(Long userId) {
        this.popOnceStrategy.cache(this.buildPopContext(userId));
    }

    private PopContext buildPopContext(Long userId) {
        PopContext popContext = new PopContext();
        popContext.setHomeWindowParam(this.buildHomeWindowParam(userId));
        popContext.addParam("key", PopTypeEnum.PRIVACY_POP.name());
        PopCache popCache = new PopCache();
        popCache.setPopUp(false);
        popCache.addParam("num", 1);
        HashMap<String, PopCache> cacheMap = new HashMap<String, PopCache>();
        cacheMap.put(PopTypeEnum.PRIVACY_POP.name(), popCache);
        popContext.setCacheMap(cacheMap);
        return popContext;
    }

    private HomeWindowParam buildHomeWindowParam(Long userId) {
        HomeWindowParam homeWindowParam = new HomeWindowParam();
        homeWindowParam.setUserId(userId);
        return homeWindowParam;
    }
}

