/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.service.impl;

import cn.binarywang.wx.miniapp.bean.WxMaTemplateData;
import cn.binarywang.wx.miniapp.bean.WxMaTemplateMessage;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.integration.UserAuthIntegrationService;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.param.WechatMpPushMessage;
import com.bxm.localnews.thirdparty.config.WechatProperties;
import com.bxm.localnews.thirdparty.constant.WxMaTemplateEnum;
import com.bxm.localnews.thirdparty.service.PushMessageService;
import com.bxm.localnews.thirdparty.service.WechatService;
import com.bxm.localnews.thirdparty.service.wx.push.WxMpMessageService;
import com.bxm.localnews.vo.UserAuth;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.chanjar.weixin.common.error.WxErrorException;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class PushMessageServiceImpl
implements PushMessageService {
    private static final Logger log = LoggerFactory.getLogger(PushMessageServiceImpl.class);
    private static final String WE_CHAT_PUSH_URL = "https://api.weixin.qq.com/cgi-bin/message/wxopen/template/send";
    private static final String JUMP_MSG_CENTER = "pages/home/home?tp=msg";
    private final WechatService wechatService;
    private final WechatProperties wechatProperties;
    private final RedisListAdapter redisListAdapter;
    private final RedisHashMapAdapter redisHashMapAdapter;
    private final HttpClientService httpClientService;
    private final UserAuthIntegrationService userAuthIntegrationService;
    private final WxMpMessageService wxMpMessageService;

    @Autowired
    public PushMessageServiceImpl(WechatService wechatService, WechatProperties wechatProperties, RedisListAdapter redisListAdapter, RedisHashMapAdapter redisHashMapAdapter, HttpClientService httpClientService, UserAuthIntegrationService userAuthIntegrationService, WxMpMessageService wxMpMessageService) {
        this.wechatService = wechatService;
        this.wechatProperties = wechatProperties;
        this.redisListAdapter = redisListAdapter;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.httpClientService = httpClientService;
        this.userAuthIntegrationService = userAuthIntegrationService;
        this.wxMpMessageService = wxMpMessageService;
    }

    public void pushMessage(BigDecimal cash, Long userId) {
        block7: {
            if (null == userId || null == cash) {
                return;
            }
            UserAuth userAuth = this.userAuthIntegrationService.selectAppletUserAuthByUserId(userId, Byte.valueOf((byte)7));
            if (null == userAuth) {
                return;
            }
            String userFormId = (String)this.redisListAdapter.leftPop(RedisConfig.WEIXIN_FORMID.copy().appendKey((Object)this.wechatProperties.getAppId()).appendKey((Object)userId), String.class);
            if (userFormId == null) {
                return;
            }
            JSONObject data = new JSONObject();
            JSONObject keyword1 = new JSONObject();
            JSONObject keyword2 = new JSONObject();
            keyword1.put("value", (Object)("\u5165\u8d26" + cash.stripTrailingZeros().toPlainString() + "\u5143"));
            keyword2.put("value", (Object)"\u5206\u4eab\u8d8a\u591a\u5956\u91d1\u8d8a\u591a\uff0c\u70b9\u51fb\u53bb\u63d0\u73b0");
            data.put("keyword1", (Object)keyword1);
            data.put("keyword2", (Object)keyword2);
            JSONObject parameters = new JSONObject();
            parameters.put("access_token", (Object)this.wechatService.getWeChatToken());
            parameters.put("touser", (Object)userAuth.getIdentifier());
            parameters.put("template_id", (Object)this.wechatProperties.getTemplateId());
            parameters.put("form_id", (Object)userFormId);
            parameters.put("data", (Object)data);
            parameters.put("emphasis_keyword", (Object)"keyword1.DATA");
            String page = this.wechatProperties.getPushPage();
            if (!page.endsWith("?")) {
                page = page + "?";
            }
            page = page + "inviteUserId=";
            parameters.put("page", (Object)page);
            if (log.isDebugEnabled()) {
                log.debug("weChat push params:{}", (Object)parameters);
            }
            try {
                JSONObject result = JSON.parseObject((String)this.httpClientService.doPostJson("https://api.weixin.qq.com/cgi-bin/message/wxopen/template/send?access_token=" + this.wechatService.getWeChatToken(), parameters.toJSONString()));
                log.info("weChat push result:{}", (Object)result.toJSONString());
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block7;
                log.info("weChat push error", (Throwable)e);
            }
        }
    }

    @Async
    public void pushTemplateMessage(PushMessage message, String appId) {
        WxMaTemplateEnum templateEnum;
        if (StringUtils.isEmpty((CharSequence)appId)) {
            appId = this.wechatProperties.getWstAppId();
        }
        if (null == (templateEnum = WxMaTemplateEnum.getTemplateEnumByType((int)message.getPayloadInfo().getType()))) {
            return;
        }
        String templateId = templateEnum.getTemplateId();
        Object userIds = message.getPushReceiveScope().getRuleParam().get("userIds");
        if (null == userIds) {
            return;
        }
        log.debug("\u7528\u6237\u4fe1\u606f\uff1a" + JSON.toJSONString(userIds));
        Long userId = Long.valueOf(userIds.toString());
        UserAuth userAuth = this.userAuthIntegrationService.selectAppletUserAuthByUserId(userId, Byte.valueOf((byte)8));
        if (null == userAuth) {
            return;
        }
        log.debug("\u7528\u6237auth\uff1a" + JSON.toJSONString((Object)userAuth));
        List<WxMaTemplateData> wxMaTemplateDataList = this.generateTemplate(message, templateEnum);
        if (CollectionUtils.isEmpty(wxMaTemplateDataList)) {
            return;
        }
        String emphasisKeyword = this.getEmphasisKeyword(templateEnum);
        this.sendTemplate(appId, userId, templateId, wxMaTemplateDataList, userAuth.getIdentifier(), emphasisKeyword);
    }

    private List<WxMaTemplateData> generateTemplate(PushMessage message, WxMaTemplateEnum wxMaTemplateEnum) {
        Map extend = message.getPayloadInfo().getExtend();
        log.debug("\u6784\u9020\u6a21\u677f\u6d88\u606f\u6240\u9700\u5b57\u6bb5\uff1a" + JSON.toJSONString((Object)extend));
        if (null == extend || CollectionUtils.isEmpty(extend.keySet())) {
            return null;
        }
        ArrayList<String> valueList = new ArrayList<String>();
        String nickname = extend.get("nickname") + "";
        if (StringUtils.isBlank((CharSequence)nickname) || "null".equals(nickname)) {
            nickname = "\u795e\u79d8\u4eba";
        }
        if (PushMessageEnum.BELONG_POST_LIKE.name().equals(wxMaTemplateEnum.name())) {
            valueList.add(nickname);
            valueList.add("\ud83c\udf39\u4f60\u83b7\u5f97" + extend.get("flowerNum") + "\u6735\u82b1");
            valueList.add(extend.get("postTitle") + "");
            valueList.add(DateUtils.getCurrentDateTime());
        } else if (PushMessageEnum.BELONG_POST_REPLY.name().equals(wxMaTemplateEnum.name())) {
            valueList.add("\ud83d\udd25\u6709\u4eba\u8bc4\u8bba\u4e86\u4f60\u7684\u5185\u5bb9");
            valueList.add(nickname);
            valueList.add(extend.get("replyContent") + "");
            valueList.add(DateUtils.getCurrentDateTime());
        } else if (PushMessageEnum.NEWS_LIKE.name().equals(wxMaTemplateEnum.name()) || PushMessageEnum.POST_LIKE.name().equals(wxMaTemplateEnum.name())) {
            valueList.add("\ud83d\udc4d\u6709\u4eba\u70b9\u8d5e\u4e86\u4f60\u7684\u8bc4\u8bba");
            valueList.add(nickname);
            valueList.add(extend.get("replyContent") + "");
            valueList.add(DateUtils.getCurrentDateTime());
        } else if (PushMessageEnum.NEWS_REPLY.name().equals(wxMaTemplateEnum.name()) || PushMessageEnum.POST_REPLY.name().equals(wxMaTemplateEnum.name())) {
            valueList.add("\u270d\u6709\u4eba\u56de\u590d\u4e86\u4f60\u7684\u8bc4\u8bba");
            valueList.add(nickname);
            valueList.add(extend.get("replyContent") + "");
            valueList.add(DateUtils.getCurrentDateTime());
        } else if (PushMessageEnum.FORWARDING.name().equals(wxMaTemplateEnum.name())) {
            valueList.add("\u521a\u521a\u6709\u4eba\u9605\u8bfb\u4e86\u4f60\u5206\u4eab\u7684\u5185\u5bb9");
            valueList.add(nickname);
            valueList.add("\ud83c\udf39\u4f60\u83b7\u5f97" + extend.get("flowerNum") + "\u6735\u82b1");
            valueList.add(DateUtils.getCurrentDateTime());
        } else if (PushMessageEnum.INVITE.name().equals(wxMaTemplateEnum.name())) {
            Object userType = extend.get("userType");
            if (null == userType) {
                return null;
            }
            if (0 == Integer.valueOf(userType.toString())) {
                valueList.add(extend.get("nickname") + "\uff08\u65b0\u7528\u6237\uff09");
                valueList.add(extend.get("nickname") + "\u6536\u5230\u4e86\u4f60\u7684\u9080\u8bf7\uff0c\u52a0\u5165\u672c\u5730\u4e07\u4e8b\u901a");
            } else {
                valueList.add(extend.get("nickname") + "\uff08\u8001\u7528\u6237\uff09");
                valueList.add(extend.get("nickname") + "\u6536\u5230\u4e86\u4f60\u7684\u9080\u8bf7\uff0c\u518d\u6b21\u56de\u5230\u672c\u5730\u4e07\u4e8b\u901a");
            }
            valueList.add("\ud83c\udf39\u4f60\u83b7\u5f97" + extend.get("flowerNum") + "\u6735\u82b1");
            valueList.add(DateUtils.getCurrentDateTime());
        }
        return this.generateDataList(valueList);
    }

    private List<WxMaTemplateData> generateDataList(List<String> valueList) {
        ArrayList<WxMaTemplateData> wxMaTemplateDataList = new ArrayList<WxMaTemplateData>();
        for (int i = 0; i < valueList.size(); ++i) {
            WxMaTemplateData keyword = new WxMaTemplateData();
            keyword.setName("keyword" + (i + 1));
            keyword.setValue(valueList.get(i));
            wxMaTemplateDataList.add(keyword);
        }
        return wxMaTemplateDataList;
    }

    private String getEmphasisKeyword(WxMaTemplateEnum wxMaTemplateEnum) {
        if (PushMessageEnum.BELONG_POST_LIKE.name().equals(wxMaTemplateEnum.name())) {
            return "keyword2.DATA";
        }
        if (PushMessageEnum.FORWARDING.name().equals(wxMaTemplateEnum.name())) {
            return "keyword3.DATA";
        }
        if (PushMessageEnum.INVITE.name().equals(wxMaTemplateEnum.name())) {
            return "keyword3.DATA";
        }
        return null;
    }

    private void sendTemplate(String appId, Long userId, String templateId, List<WxMaTemplateData> list, String openId, String emphasisKeyword) {
        String userFormId = (String)this.redisListAdapter.leftPop(RedisConfig.WEIXIN_FORMID.copy().appendKey((Object)appId).appendKey((Object)userId), String.class);
        if (userFormId == null) {
            return;
        }
        log.debug("form id: " + userFormId);
        try {
            log.debug("\u7ed9\u7528\u6237[{}]\u53d1\u9001[{}]\u6a21\u677f\u6d88\u606f", (Object)openId, (Object)templateId);
            this.wechatService.getWxMaService(appId).getMsgService().sendTemplateMsg(WxMaTemplateMessage.builder().templateId(templateId).formId(userFormId).data(list).toUser(openId).page(JUMP_MSG_CENTER).emphasisKeyword(emphasisKeyword).build());
        }
        catch (WxErrorException e) {
            log.warn("\u7ed9\u7528\u6237\u53d1\u9001\u6a21\u677f\u6d88\u606f\u5931\u8d25", (Throwable)e);
            this.sendTemplate(appId, userId, templateId, list, openId, emphasisKeyword);
        }
    }

    public Message pushOfficialAccountMsg(WechatMpPushMessage wechatMpPushMessage) {
        return this.wxMpMessageService.singlePush(wechatMpPushMessage);
    }
}

