/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.activity.service.RedPacketFacadeService;
import com.bxm.localnews.base.service.AppVersionSupplyService;
import com.bxm.localnews.base.service.AreaWhiteBlackService;
import com.bxm.localnews.base.service.LocationFacadeService;
import com.bxm.localnews.common.constant.AreaWhiteBlackKeyEnum;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.thirdparty.config.TooltipProperties;
import com.bxm.localnews.thirdparty.constant.ToolsSensitiveFlagEnum;
import com.bxm.localnews.thirdparty.domain.ToolsLocationMapper;
import com.bxm.localnews.thirdparty.domain.ToolsMapper;
import com.bxm.localnews.thirdparty.dto.ToolsDTO;
import com.bxm.localnews.thirdparty.service.ToolsService;
import com.bxm.localnews.thirdparty.vo.Tools;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ToolsServiceImpl
implements ToolsService {
    private static final Logger LOG = LoggerFactory.getLogger(ToolsServiceImpl.class);
    private static final List<String> REPLACE_LIST = Lists.newArrayList((Object[])new String[]{"{uid}"});
    private ToolsMapper toolsMapper;
    private ToolsLocationMapper toolsLocationMapper;
    private AppVersionSupplyService appVersionSupplyService;
    private LocationFacadeService locationFacadeService;
    private AreaWhiteBlackService areaWhiteBlackService;
    private RedPacketFacadeService redPacketFacadeService;
    private TooltipProperties tooltipProperties;

    @Autowired
    public ToolsServiceImpl(ToolsMapper toolsMapper, ToolsLocationMapper toolsLocationMapper, AppVersionSupplyService appVersionSupplyService, LocationFacadeService locationFacadeService, AreaWhiteBlackService areaWhiteBlackService, RedPacketFacadeService redPacketFacadeService, TooltipProperties tooltipProperties) {
        this.toolsMapper = toolsMapper;
        this.toolsLocationMapper = toolsLocationMapper;
        this.appVersionSupplyService = appVersionSupplyService;
        this.locationFacadeService = locationFacadeService;
        this.areaWhiteBlackService = areaWhiteBlackService;
        this.redPacketFacadeService = redPacketFacadeService;
        this.tooltipProperties = tooltipProperties;
    }

    @Override
    public List<ToolsDTO> getToolsByAreaCode(String areaCode, Long userId, Integer isLogin, BasicParam basicParam, Byte locationType) {
        Boolean isPublishState = this.appVersionSupplyService.getPublishState(basicParam);
        List<ToolsDTO> toolsDTOS = this.getToolDTOsByToolsList(areaCode, isPublishState, locationType, userId, basicParam.getCurVer());
        ArrayList list = Lists.newArrayList();
        if (isLogin == 1) {
            list.add(userId.toString());
        } else {
            list.add("");
        }
        toolsDTOS.forEach(t -> {
            for (int i = 0; i < REPLACE_LIST.size(); ++i) {
                String str = REPLACE_LIST.get(i);
                if (!t.getUrl().contains(REPLACE_LIST.get(i))) continue;
                t.setUrl(t.getUrl().replace(str, (CharSequence)list.get(i)));
            }
        });
        return toolsDTOS;
    }

    private List<Tools> getRealTools(String areaCode) {
        String fullAreaCode = this.locationFacadeService.completeAreaCode(areaCode);
        List cacheToolsList = this.areaWhiteBlackService.getCacheByAreaCode(AreaWhiteBlackKeyEnum.TOOLS.getKey(), fullAreaCode, (TypeReference)new TypeReference<List<Tools>>(){});
        if (CollectionUtils.isNotEmpty((Collection)cacheToolsList)) {
            return cacheToolsList;
        }
        List allToolsList = this.toolsMapper.getAllTools();
        List whiteAreaList = this.toolsLocationMapper.getToolLocationByType(areaCode, Integer.valueOf(1));
        List blackAreaList = this.toolsLocationMapper.getToolLocationByType(areaCode, Integer.valueOf(2));
        List realToolsList = this.areaWhiteBlackService.filterCacheByAreaCode(allToolsList, whiteAreaList, blackAreaList);
        this.areaWhiteBlackService.setCacheByAreaCode(AreaWhiteBlackKeyEnum.TOOLS.getKey(), fullAreaCode, realToolsList);
        LOG.info("\u6839\u636e\u5730\u533a{}\u83b7\u53d6\u5f97\u5230\u7684\u5de5\u5177\u5217\u8868\u4fe1\u606f\u4e3a:{}", (Object)areaCode, (Object)JSON.toJSONString((Object)realToolsList));
        return realToolsList;
    }

    private ToolsDTO getToolsDTOByTools(Tools tools) {
        ToolsDTO toolsDTO = new ToolsDTO();
        BeanUtils.copyProperties((Object)tools, (Object)toolsDTO);
        return toolsDTO;
    }

    private List<ToolsDTO> getToolDTOsByToolsList(String areaCode, Boolean isPublishState, Byte locationType, Long userId, String curVer) {
        List<Object> toolsList = this.getRealTools(areaCode);
        this.getTooltipByStrategy(toolsList, userId, areaCode);
        toolsList = locationType != null && locationType == 1 ? toolsList.stream().filter(tools -> tools.getHomeFlag() != null && tools.getHomeFlag() == 1).collect(Collectors.toList()) : toolsList.stream().filter(tools -> tools.getHomeFlag() == null || tools.getHomeFlag() == 0).collect(Collectors.toList());
        List<ToolsDTO> toolsDTOS = toolsList.stream().filter(tools -> isPublishState == false || !ToolsSensitiveFlagEnum.IS_SENSITIVE.getState().equals(tools.getSensitiveFlag())).map(this::getToolsDTOByTools).collect(Collectors.toList());
        return toolsDTOS;
    }

    private List<Tools> getTop5ForList(List<Tools> toolsList) {
        if (toolsList.size() > 5) {
            ArrayList tools = Lists.newArrayList();
            for (int i = 0; i < 5; ++i) {
                tools.add(toolsList.get(i));
            }
            return tools;
        }
        return toolsList;
    }

    private void getTooltipByStrategy(List<Tools> toolsList, Long userId, String areaCode) {
        for (Tools toolInfo : toolsList) {
            if (!"RED_PACKET".equals(toolInfo.getTooltip())) continue;
            if (this.redPacketFacadeService.getHasAvailableRedPacket(userId, areaCode).booleanValue()) {
                toolInfo.setTooltip(this.tooltipProperties.getRedPacket());
                continue;
            }
            toolInfo.setTooltip(null);
        }
    }
}

