/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.thirdparty.config.FutureWeatherProperties;
import com.bxm.localnews.thirdparty.config.WeatherProperties;
import com.bxm.localnews.thirdparty.config.WindFutureWeatherProperties;
import com.bxm.localnews.thirdparty.constant.WeatherEnum;
import com.bxm.localnews.thirdparty.dto.WeatherDTO;
import com.bxm.localnews.thirdparty.dto.WeatherExtendDTO;
import com.bxm.localnews.thirdparty.service.WeatherService;
import com.bxm.newidea.component.oss.service.AliyunOSSService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WeatherServiceImpl
implements WeatherService {
    private static final Logger logger = LoggerFactory.getLogger(WeatherServiceImpl.class);
    private WeatherProperties weatherProperties;
    private FutureWeatherProperties futureWeatherProperties;
    private HttpClientService httpClientService;
    private RedisStringAdapter redisStringAdapter;
    private AliyunOSSService aliyunOSSService;
    private WindFutureWeatherProperties windFutureWeatherProperties;

    @Autowired
    public WeatherServiceImpl(WeatherProperties weatherProperties, FutureWeatherProperties futureWeatherProperties, HttpClientService httpClientService, RedisStringAdapter redisStringAdapter, AliyunOSSService aliyunOSSService, WindFutureWeatherProperties windFutureWeatherProperties) {
        this.weatherProperties = weatherProperties;
        this.futureWeatherProperties = futureWeatherProperties;
        this.httpClientService = httpClientService;
        this.redisStringAdapter = redisStringAdapter;
        this.aliyunOSSService = aliyunOSSService;
        this.windFutureWeatherProperties = windFutureWeatherProperties;
    }

    @Override
    public WeatherDTO getWeatherByAdcode(String adcode) {
        WeatherDTO weatherDTO = (WeatherDTO)this.redisStringAdapter.get(this.getWeatherKey(adcode), WeatherDTO.class);
        if (weatherDTO == null) {
            HashMap<String, String> map = this.addCommonParams(adcode, "base");
            String json = this.httpClientService.doGet(this.weatherProperties.getWeatherUrl(), map);
            weatherDTO = this.getWeatherByJson(json);
        }
        return weatherDTO;
    }

    @Override
    public WeatherDTO getHomeWeatherByAdcode(String adcode) {
        WeatherDTO weatherDTO = this.getWeatherByAdcode(adcode);
        this.setHomeWeather(weatherDTO);
        return weatherDTO;
    }

    @Override
    public List<WeatherExtendDTO> getFutureWeather(String adcode) {
        com.fasterxml.jackson.core.type.TypeReference<List<WeatherExtendDTO>> typeReference = new com.fasterxml.jackson.core.type.TypeReference<List<WeatherExtendDTO>>(){};
        List<WeatherExtendDTO> weatherExtendDTOS = (List<WeatherExtendDTO>)this.redisStringAdapter.get(this.getFutureWeatherKey(adcode), (com.fasterxml.jackson.core.type.TypeReference)typeReference);
        if (CollectionUtils.isEmpty((Collection)weatherExtendDTOS)) {
            HashMap<String, String> params = this.addWindParams(adcode);
            String json = this.httpClientService.doGet(this.windFutureWeatherProperties.getWeatherUrl(), params);
            weatherExtendDTOS = this.parseFutureWeather(json);
            if (CollectionUtils.isEmpty(weatherExtendDTOS)) {
                params = this.addCommonParams(adcode, "all");
                json = this.httpClientService.doGet(this.weatherProperties.getWeatherUrl(), params);
                weatherExtendDTOS = this.parseFutureWeatherByMap(json);
            }
            if (CollectionUtils.isNotEmpty(weatherExtendDTOS)) {
                this.redisStringAdapter.set(this.getFutureWeatherKey(adcode), weatherExtendDTOS, 3600L);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)weatherExtendDTOS)) {
            weatherExtendDTOS.forEach(weatherExtendDTO -> this.setHomeWeather((WeatherDTO)weatherExtendDTO));
        }
        return weatherExtendDTOS;
    }

    private void setHomeWeather(WeatherDTO weatherDTO) {
        WeatherEnum weatherEnum = WeatherEnum.getWeatherEnum((String)weatherDTO.getWeather());
        weatherDTO.setWeather(weatherEnum == null ? "" : weatherEnum.getName());
        weatherDTO.setWeatherImg(weatherEnum == null ? "" : weatherEnum.getHomeImg());
    }

    private HashMap<String, String> addCommonParams(String adcode, String extensions) {
        HashMap map = Maps.newHashMap();
        map.put("key", this.weatherProperties.getKey());
        map.put("city", adcode);
        map.put("extensions", extensions);
        return map;
    }

    private HashMap<String, String> addWindParams(String adcode) {
        HashMap map = Maps.newHashMap();
        map.put("key", this.windFutureWeatherProperties.getKey());
        map.put("location", adcode);
        return map;
    }

    private WeatherDTO getWeatherByJson(String json) {
        WeatherDTO weatherDTO = new WeatherDTO();
        if (StringUtils.isBlank((CharSequence)json)) {
            return weatherDTO;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)json);
        if ("0".equals(jsonObject.getString("status"))) {
            return weatherDTO;
        }
        JSONArray jsonArray = jsonObject.getJSONArray("lives");
        TypeReference<List<WeatherDTO>> typeReference = new TypeReference<List<WeatherDTO>>(){};
        List weatherDTOS = (List)JSON.parseObject((String)jsonArray.toJSONString(), (TypeReference)typeReference, (Feature[])new Feature[0]);
        if (CollectionUtils.isNotEmpty((Collection)weatherDTOS)) {
            WeatherEnum weatherEnum = WeatherEnum.getWeatherEnum((String)(weatherDTO = (WeatherDTO)weatherDTOS.get(0)).getWeather());
            weatherDTO.setWeather(weatherEnum == null ? "" : weatherEnum.getName());
            weatherDTO.setWeatherImg(weatherEnum == null ? "" : weatherEnum.getImg());
            weatherDTO.setTemperature(weatherDTO.getTemperature() + "\u00b0");
            this.redisStringAdapter.set(this.getWeatherKey(weatherDTO.getAdcode()), (Object)weatherDTO, 1800L);
        }
        return weatherDTO;
    }

    private List<WeatherExtendDTO> convertWeatherExtend(JSONArray jsonArray) {
        ArrayList weatherExtendDTOS = Lists.newArrayList();
        for (int i = 0; i < jsonArray.size(); ++i) {
            weatherExtendDTOS.add(this.convertWeather(jsonArray.getJSONObject(i)));
        }
        return weatherExtendDTOS;
    }

    private WeatherExtendDTO convertWeather(JSONObject jsonObject) {
        WeatherExtendDTO weatherExtendDTO = new WeatherExtendDTO();
        String maxtmp = jsonObject.getString("tmp_max");
        String mintmp = jsonObject.getString("tmp_min");
        weatherExtendDTO.setMaxTemp(maxtmp);
        weatherExtendDTO.setMinTemp(mintmp);
        String date = jsonObject.getString("date");
        weatherExtendDTO.setDate(DateUtils.formatAtWill((Date)DateUtils.parse((String)date), (String)"MM/dd"));
        Date now = new Date();
        int diffDay = DateUtils.getDiffDays((Date)DateUtils.parse((String)date), (Date)DateUtils.parse((String)DateUtils.formatAtWill((Date)now, (String)"yyyy-MM-dd")), (boolean)true);
        weatherExtendDTO.setWeek(this.dateToWeek(date));
        if (diffDay == 0) {
            weatherExtendDTO.setWeek("\u4eca\u5929");
        } else if (diffDay == 1) {
            weatherExtendDTO.setWeek("\u660e\u5929");
        }
        weatherExtendDTO.setHumidity(jsonObject.getString("hum"));
        weatherExtendDTO.setWindpower(jsonObject.getString("wind_sc"));
        weatherExtendDTO.setWinddirection(jsonObject.getString("wind_dir"));
        weatherExtendDTO.setWeather(jsonObject.getString("cond_txt_d"));
        WeatherEnum weatherEnum = WeatherEnum.getWeatherEnum((String)weatherExtendDTO.getWeather());
        if (weatherEnum != null) {
            weatherExtendDTO.setWeatherImg(weatherEnum.getImg());
        } else {
            logger.info("\u5f53\u5929\u7684\u5929\u6c14\u4fe1\u606f\u4e3a\uff1a{}", (Object)weatherExtendDTO.getWeather());
        }
        weatherExtendDTO.setWeatherType(this.convertWeatherType(weatherExtendDTO.getWeather()));
        return weatherExtendDTO;
    }

    private List<WeatherExtendDTO> parseFutureWeather(String json) {
        List<Object> weatherExtendDTOS = Lists.newArrayList();
        if (StringUtils.isBlank((CharSequence)json)) {
            return weatherExtendDTOS;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)json);
        JSONArray resultJsonArray = jsonObject.getJSONArray("HeWeather6");
        JSONObject result = resultJsonArray.getJSONObject(0);
        if (!"ok".equals(result.getString("status"))) {
            return weatherExtendDTOS;
        }
        JSONArray jsonArray = result.getJSONArray("daily_forecast");
        weatherExtendDTOS = this.convertWeatherExtend(jsonArray);
        return weatherExtendDTOS;
    }

    private List<WeatherExtendDTO> parseFutureWeatherByMap(String json) {
        ArrayList weatherExtendDTOS = Lists.newArrayList();
        if (StringUtils.isEmpty((CharSequence)json)) {
            return weatherExtendDTOS;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)json);
        if ("0".equals(jsonObject.getString("status"))) {
            return weatherExtendDTOS;
        }
        JSONArray resultJsonArray = jsonObject.getJSONArray("forecasts");
        JSONArray jsonArray = resultJsonArray.getJSONObject(0).getJSONArray("casts");
        for (int i = 0; i < jsonArray.size(); ++i) {
            weatherExtendDTOS.add(this.convertMapWeather(jsonArray.getJSONObject(i)));
        }
        return weatherExtendDTOS;
    }

    private WeatherExtendDTO convertMapWeather(JSONObject jsonObject) {
        WeatherExtendDTO weatherExtendDTO = new WeatherExtendDTO();
        String date = jsonObject.getString("date");
        weatherExtendDTO.setDate(DateUtils.formatAtWill((Date)DateUtils.parse((String)date), (String)"MM/dd"));
        Date now = new Date();
        int diffDay = DateUtils.getDiffDays((Date)DateUtils.parse((String)date), (Date)DateUtils.parse((String)DateUtils.formatAtWill((Date)now, (String)"yyyy-MM-dd")), (boolean)true);
        weatherExtendDTO.setWeek(this.dateToWeek(date));
        if (diffDay == 0) {
            weatherExtendDTO.setWeek("\u4eca\u5929");
        } else if (diffDay == 1) {
            weatherExtendDTO.setWeek("\u660e\u5929");
        }
        weatherExtendDTO.setWeather(jsonObject.getString("dayweather"));
        weatherExtendDTO.setMaxTemp(jsonObject.getString("daytemp"));
        weatherExtendDTO.setMinTemp(jsonObject.getString("nighttemp"));
        weatherExtendDTO.setWinddirection(jsonObject.getString("daywind"));
        weatherExtendDTO.setWindpower(jsonObject.getString("daypower"));
        WeatherEnum weatherEnum = WeatherEnum.getWeatherEnum((String)weatherExtendDTO.getWeather());
        if (weatherEnum != null) {
            weatherExtendDTO.setWeatherImg(weatherEnum.getImg());
        } else {
            logger.info("\u5f53\u5929\u7684\u5929\u6c14\u4fe1\u606f\u4e3a\uff1a{}", (Object)weatherExtendDTO.getWeather());
        }
        weatherExtendDTO.setWeatherType(this.convertWeatherType(weatherExtendDTO.getWeather()));
        return weatherExtendDTO;
    }

    private KeyGenerator getWeatherKey(String areaCode) {
        return RedisConfig.THIRDPARTY_WEATHER.copy().appendKey((Object)areaCode);
    }

    private KeyGenerator getFutureWeatherKey(String areaCode) {
        return RedisConfig.THIRDPARTY_FUTURE_WEATHER.copy().appendKey((Object)areaCode);
    }

    private String dateToWeek(String datetime) {
        String[] weekDays = new String[]{"\u5468\u65e5", "\u5468\u4e00", "\u5468\u4e8c", "\u5468\u4e09", "\u5468\u56db", "\u5468\u4e94", "\u5468\u516d"};
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.parse((String)datetime));
        int w = cal.get(7) - 1;
        if (w < 0) {
            w = 0;
        }
        return weekDays[w];
    }

    private Byte convertWeatherType(String weather) {
        Byte[] weatherType = new Byte[]{(byte)1, (byte)2, (byte)3, (byte)4, (byte)5};
        if (weather.contains("\u4e91")) {
            return weatherType[0];
        }
        if (weather.contains("\u6674")) {
            return weatherType[1];
        }
        if (weather.contains("\u9634")) {
            return weatherType[2];
        }
        if (weather.contains("\u96ea")) {
            return weatherType[3];
        }
        if (weather.contains("\u96e8")) {
            return weatherType[4];
        }
        return (byte)1;
    }
}

