/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.service.impl;

import com.bxm.localnews.base.service.BaseUrlFacadeService;
import com.bxm.localnews.common.constant.DomainScene;
import com.bxm.localnews.common.param.GetAvailableDomainInfoParam;
import com.bxm.localnews.common.vo.BaseUrlInfo;
import com.bxm.localnews.common.vo.ViewSceneInfo;
import com.bxm.localnews.thirdparty.config.WechatAccountConfig;
import com.bxm.localnews.thirdparty.config.WechatMPAuthConfig;
import com.bxm.localnews.thirdparty.config.WechatMPConfig;
import com.bxm.localnews.thirdparty.param.RedirectToWechatMpAuthParam;
import com.bxm.localnews.thirdparty.service.WechatMpFacadeService;
import com.bxm.localnews.thirdparty.service.impl.WechatMpService;
import com.gexin.fastjson.JSON;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import me.chanjar.weixin.common.bean.WxJsapiSignature;
import me.chanjar.weixin.common.util.http.URIUtil;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.util.WxMpConfigStorageHolder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class WechatMpServiceImpl
implements WechatMpService,
WechatMpFacadeService {
    private static final Logger log = LoggerFactory.getLogger(WechatMpServiceImpl.class);
    private final WxMpService wxMpService;
    private final BaseUrlFacadeService baseUrlFacadeService;
    private final WechatMPConfig wechatMPConfig;
    private final WechatMPAuthConfig wechatMPAuthConfig;
    private final WechatAccountConfig wechatAccountConfig;

    @Override
    public String wechatMpAuthUrlGen(RedirectToWechatMpAuthParam param) {
        if (StringUtils.isBlank((CharSequence)param.getScene())) {
            log.warn("\u83b7\u53d6\u5fae\u4fe1\u6388\u6743/\u652f\u4ed8\u91cd\u5b9a\u5411url\u5931\u8d25\uff0c\u573a\u666f\u4e3a\u7a7a\uff0cparam: {}", (Object)JSON.toJSONString((Object)param));
            return param.getRedirectUrl();
        }
        GetAvailableDomainInfoParam infoParam = new GetAvailableDomainInfoParam();
        infoParam.setScene(param.getScene());
        if (Objects.equals(Objects.toString(DomainScene.WECHAT_PAY), param.getScene())) {
            infoParam.setAppId(this.wechatMPConfig.getActive().getActiveAppId());
        } else {
            infoParam.setAppId(this.wechatAccountConfig.getJsapiAppId());
        }
        BaseUrlInfo domainInfo = this.baseUrlFacadeService.getBaseUrlInfo(infoParam);
        if (Objects.isNull(domainInfo) || StringUtils.isBlank((CharSequence)domainInfo.getBaseUrl())) {
            log.warn("\u6839\u636e\u573a\u666f: {} \u83b7\u53d6\u57df\u540d\u5931\u8d25\uff0cparam: {}, infoParam: {}", new Object[]{param.getScene(), JSON.toJSONString((Object)param), JSON.toJSONString((Object)infoParam)});
            return param.getRedirectUrl();
        }
        String urlForScene = this.wechatMPAuthConfig.getAuthPath().get(param.getScene());
        String authUrlWithParam = StringUtils.join((Object[])new String[]{domainInfo.getBaseUrl(), urlForScene, "?", "redirectUrl=", URIUtil.encodeURIComponent((String)param.getRedirectUrl())});
        String finalRedirectUrl = this.wxMpService.oauth2buildAuthorizationUrl(authUrlWithParam, param.getScope(), param.getState());
        if (log.isDebugEnabled()) {
            log.debug("\u751f\u6210\u7684 finalRedirectUrl: {}", (Object)finalRedirectUrl);
        }
        return finalRedirectUrl;
    }

    @Override
    public WxJsapiSignature createJsApiSignature(String sourceUrl) {
        try {
            URL urlInstance = new URL(sourceUrl);
            List viewSceneByDomain = this.baseUrlFacadeService.getViewSceneByDomain(urlInstance.getHost());
            String wxJsView = Objects.toString(DomainScene.DomainViewScene.WX_JS_VIEW);
            Optional<ViewSceneInfo> first = viewSceneByDomain.stream().filter(p -> Objects.equals(p.getViewScene(), wxJsView) && StringUtils.isNotBlank((CharSequence)p.getAppId())).findFirst();
            if (!first.isPresent()) {
                log.warn("\u57df\u540d: {} \u83b7\u53d6\u4e0d\u5230\u5bf9\u5e94\u914d\u7f6e\u7684app id", (Object)urlInstance.getHost());
                return null;
            }
            String appId = first.get().getAppId();
            log.info("\u57df\u540d: {} \u83b7\u53d6\u5230\u7684appId: {}", (Object)urlInstance.getHost(), (Object)appId);
            WxMpConfigStorageHolder.set((String)appId);
            WxJsapiSignature jsapiSignature = this.wxMpService.createJsapiSignature(sourceUrl);
            if (log.isDebugEnabled()) {
                log.debug("urL {} \u83b7\u53d6\u5230\u7684js \u9a8c\u7b7e\u4fe1\u606f: {} ", (Object)sourceUrl, JSON.toJSON((Object)jsapiSignature));
            }
            return jsapiSignature;
        }
        catch (Exception e) {
            log.error("url: {} \u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684url", (Object)sourceUrl, (Object)e);
            return null;
        }
    }

    public WechatMpServiceImpl(WxMpService wxMpService, BaseUrlFacadeService baseUrlFacadeService, WechatMPConfig wechatMPConfig, WechatMPAuthConfig wechatMPAuthConfig, WechatAccountConfig wechatAccountConfig) {
        this.wxMpService = wxMpService;
        this.baseUrlFacadeService = baseUrlFacadeService;
        this.wechatMPConfig = wechatMPConfig;
        this.wechatMPAuthConfig = wechatMPAuthConfig;
        this.wechatAccountConfig = wechatAccountConfig;
    }
}

