/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.service.jump;

import com.bxm.localnews.thirdparty.constant.OrderJumpType;
import com.bxm.localnews.thirdparty.param.JumpInfoConvertParam;
import com.bxm.localnews.thirdparty.service.jump.JumpInfoConvert;
import com.bxm.localnews.thirdparty.service.jump.exception.ConvertNotFoundException;
import com.bxm.localnews.thirdparty.vo.JumpInfo;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class JumpInfoConvertService {
    private static final Logger log = LoggerFactory.getLogger(JumpInfoConvertService.class);
    private static final Map<OrderJumpType, JumpInfoConvert> JUMP_TYPE_JUMP_INFO_CONVERT_MAP = Maps.newHashMap();

    public Optional<JumpInfo> convert(JumpInfoConvertParam param) {
        Optional orderJumpType = OrderJumpType.typeValueOf((byte)param.getJumpType());
        if (!orderJumpType.isPresent()) {
            throw new ConvertNotFoundException(String.format("\u7c7b\u578b: %s\u6ca1\u6709\u53ef\u7528\u7684JumpInfoConvert", param.getJumpType()));
        }
        return this.getConvert((OrderJumpType)orderJumpType.get()).convert(param);
    }

    private JumpInfoConvert getConvert(OrderJumpType jumpType) {
        JumpInfoConvert jumpInfoConvert = JUMP_TYPE_JUMP_INFO_CONVERT_MAP.get(jumpType);
        if (Objects.isNull(jumpInfoConvert)) {
            throw new ConvertNotFoundException(String.format("\u7c7b\u578b: %s\u6ca1\u6709\u53ef\u7528\u7684JumpInfoConvert", jumpType));
        }
        return jumpInfoConvert;
    }

    @EventListener(value={ContextRefreshedEvent.class})
    public void onContextRefreshedEvent(ContextRefreshedEvent event) {
        Collection values = event.getApplicationContext().getBeansOfType(JumpInfoConvert.class).values();
        if (CollectionUtils.isEmpty(values)) {
            return;
        }
        values.forEach(p -> JUMP_TYPE_JUMP_INFO_CONVERT_MAP.put(p.support(), (JumpInfoConvert)p));
    }
}

