/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.service.pop.popinstance.impl;

import com.bxm.localnews.base.service.LocationFacadeService;
import com.bxm.localnews.common.dto.LocationDetailDTO;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.dto.VipInfoDetailDTO;
import com.bxm.localnews.integration.UserVipIntegrationService;
import com.bxm.localnews.param.VipQueryParam;
import com.bxm.localnews.thirdparty.param.HomeWindowParam;
import com.bxm.localnews.thirdparty.service.pop.popinstance.PopCache;
import com.bxm.localnews.thirdparty.service.pop.popinstance.PopContext;
import com.bxm.localnews.thirdparty.service.pop.popinstance.impl.AbstractPop;
import com.bxm.localnews.user.enums.LocalNewsUserJudgeMarkerEnum;
import com.bxm.newidea.component.tools.BitOperatorUtil;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractGuidePopup
extends AbstractPop {
    private static final Logger log = LoggerFactory.getLogger(AbstractGuidePopup.class);
    protected static final String VER_3_5_0 = "3.5.0";
    protected static final String VER_3_9_0 = "3.9.0";
    @Autowired
    private LocationFacadeService locationFacadeService;
    @Autowired
    private UserVipIntegrationService userVipIntegrationService;
    static final String LOCATION_DETAIL_DTO = "LOCATION_DETAIL_DTO";

    @Override
    public boolean beforeFilter(PopContext context) {
        HomeWindowParam param = context.getHomeWindowParam();
        if (StringUtils.isBlank((CharSequence)param.getCurVer()) || StringUtils.isNotBlank((CharSequence)this.afterIncludeVersion()) && com.bxm.newidea.component.tools.StringUtils.isLessThan((String)param.getCurVer(), (String)this.afterIncludeVersion()) || StringUtils.isNotBlank((CharSequence)this.beforeExcludeVersion()) && com.bxm.newidea.component.tools.StringUtils.isGrateOrEqualThan((String)param.getCurVer(), (String)this.beforeExcludeVersion())) {
            PopCache cache;
            String key = (String)context.getParam("key");
            if (StringUtils.isNotBlank((CharSequence)key) && (Objects.isNull(cache = context.getCacheMap().get(key)) || cache.isPopUp())) {
                super.beforeFilter(context);
                super.afterFilter(context);
            }
            if (log.isDebugEnabled()) {
                log.debug("\u8bf7\u6c42\u53c2\u6570: {} \u5173\u95ed\u5f15\u5bfc\u5f39\u7a97", (Object)param.getCurVer());
            }
            return false;
        }
        return super.beforeFilter(context);
    }

    @Override
    boolean filter(PopContext context) {
        HomeWindowParam param = context.getHomeWindowParam();
        if (Objects.isNull(param)) {
            return false;
        }
        if (!this.checkVersion(context)) {
            log.info("\u7528\u6237: {} \u7684\u5f53\u524d\u7248\u672c: {}\uff0c\u589e\u52a0\u5f39\u51fa\u7f13\u5b58\uff0c\u6c38\u4e0d\u5f39\u51fa", (Object)param.getUserId(), (Object)param.getCurVer());
            this.closeCache(context);
            return false;
        }
        LocationDetailDTO locationDetailDTO = this.locationFacadeService.getLocationDetailByCode(param.getAreaCode());
        if (Objects.isNull(locationDetailDTO) || !Objects.equals(locationDetailDTO.getEnableCommunityContent(), 1)) {
            if (log.isDebugEnabled()) {
                log.debug("\u5f53\u524d\u57ce\u5e02: {} \u4e0d\u662f\u5f00\u901a\u57ce\u5e02\uff0c\u4e0d\u5f39\u51fa\u5f15\u5bfc\u5f39\u7a97", (Object)param.getAreaCode());
            }
            return false;
        }
        context.getParamMap().put(LOCATION_DETAIL_DTO, locationDetailDTO);
        return true;
    }

    protected String afterIncludeVersion() {
        return VER_3_5_0;
    }

    protected String beforeExcludeVersion() {
        return VER_3_9_0;
    }

    protected boolean check350JudgeMarker(Long judgeMarket) {
        return BitOperatorUtil.getBitAsBoolean((Long)judgeMarket, (int)LocalNewsUserJudgeMarkerEnum.VER_3_5_0.getIndex());
    }

    protected boolean check360JudgeMarker(Long judgeMarket) {
        return BitOperatorUtil.getBitAsBoolean((Long)judgeMarket, (int)LocalNewsUserJudgeMarkerEnum.VER_3_6_0.getIndex());
    }

    protected boolean check390JudgeMarker(Long judgeMarket) {
        return BitOperatorUtil.getBitAsBoolean((Long)judgeMarket, (int)LocalNewsUserJudgeMarkerEnum.VER_3_9_0.getIndex());
    }

    protected boolean checkVersion(PopContext context) {
        String curVersion = context.getHomeWindowParam().getCurVer();
        return !(!StringUtils.isNotBlank((CharSequence)curVersion) || !StringUtils.isBlank((CharSequence)this.afterIncludeVersion()) && !com.bxm.newidea.component.tools.StringUtils.isGrateOrEqualThan((String)curVersion, (String)this.afterIncludeVersion()) || !StringUtils.isBlank((CharSequence)this.beforeExcludeVersion()) && !com.bxm.newidea.component.tools.StringUtils.isLessThan((String)curVersion, (String)this.beforeExcludeVersion()));
    }

    protected boolean isInviteVip(UserInfoDTO userInfo) {
        if (Objects.isNull(userInfo)) {
            return false;
        }
        if (!Objects.equals(userInfo.getIsVip(), 1)) {
            return false;
        }
        VipQueryParam param = new VipQueryParam();
        param.setUserId(userInfo.getId());
        VipInfoDetailDTO vipDetail = this.userVipIntegrationService.getVipDetail(param);
        return !Objects.equals(vipDetail.getType(), 0);
    }

    @Override
    public void afterFilter(PopContext context) {
        if (this.autoCache()) {
            super.afterFilter(context);
        }
    }

    protected boolean autoCache() {
        return false;
    }

    protected void closeCache(PopContext context) {
        super.afterFilter(context);
    }
}

