/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.service.pop.popinstance.impl;

import com.bxm.localnews.common.dto.LocationDetailDTO;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.thirdparty.config.PopupProperties;
import com.bxm.localnews.thirdparty.dto.HomeWindowDTO;
import com.bxm.localnews.thirdparty.dto.NormalNoviceUserGuideDTO;
import com.bxm.localnews.thirdparty.param.HomeWindowParam;
import com.bxm.localnews.thirdparty.service.pop.PopTypeEnum;
import com.bxm.localnews.thirdparty.service.pop.popinstance.PopContext;
import com.bxm.localnews.thirdparty.service.pop.popinstance.impl.AbstractGuidePopup;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class NormalUserGuidePop
extends AbstractGuidePopup {
    private static final Logger log = LoggerFactory.getLogger(NormalUserGuidePop.class);
    private final UserIntegrationService userIntegrationService;
    private final PopupProperties popupProperties;

    @Override
    boolean filter(PopContext context) {
        if (!super.filter(context)) {
            return false;
        }
        HomeWindowParam param = context.getHomeWindowParam();
        LocationDetailDTO locationDetailDTO = (LocationDetailDTO)context.getParam("LOCATION_DETAIL_DTO");
        UserInfoDTO userInfo = this.userIntegrationService.getUserFromRedisDB(param.getUserId());
        if (Objects.isNull(userInfo)) {
            log.warn("\u7528\u6237: {}\u4e0d\u5b58\u5728\uff0c\u8df3\u8fc7\u975evip\u7528\u6237\u7684\u5f15\u5bfc\u5f39\u7a97", (Object)param.getUserId());
            return false;
        }
        if (!this.check350JudgeMarker(userInfo.getJudgeMarker())) {
            log.info("\u7528\u6237: {} \u975e\u65b0\u7248\u672c\u7528\u6237 \u589e\u52a0\u5f39\u51fa\u7f13\u5b58\uff0c\u6c38\u4e0d\u5f39\u51fa", (Object)param.getUserId());
            super.closeCache(context);
            return false;
        }
        if (this.check360JudgeMarker(userInfo.getJudgeMarker())) {
            return this.version360(context, locationDetailDTO, userInfo, param);
        }
        return this.version350(context, locationDetailDTO, userInfo, param);
    }

    private boolean version360(PopContext context, LocationDetailDTO locationDetailDTO, UserInfoDTO userInfo, HomeWindowParam param) {
        this.open(context, locationDetailDTO, userInfo, param);
        return true;
    }

    private boolean version350(PopContext context, LocationDetailDTO locationDetailDTO, UserInfoDTO userInfo, HomeWindowParam param) {
        if (this.isInviteVip(userInfo)) {
            log.info("\u7528\u6237: {} \u662f\u6fc0\u6d3b\u7c7b\u578b\u7684VIP \u589e\u52a0\u666e\u901a\u5f15\u5bfc\u5f39\u7a97\u7684\u5f39\u51fa\u7f13\u5b58\uff0c\u6c38\u4e0d\u5f39\u51fa", (Object)param.getUserId());
            super.closeCache(context);
            return false;
        }
        this.open(context, locationDetailDTO, userInfo, param);
        return true;
    }

    private void open(PopContext context, LocationDetailDTO locationDetailDTO, UserInfoDTO userInfo, HomeWindowParam param) {
        NormalNoviceUserGuideDTO normalNoviceUserGuide = new NormalNoviceUserGuideDTO();
        normalNoviceUserGuide.setUserId(param.getUserId());
        normalNoviceUserGuide.setImgUrl(userInfo.getHeadImg());
        normalNoviceUserGuide.setNickName(userInfo.getNickname());
        normalNoviceUserGuide.setTitle(String.format(this.popupProperties.getNormalNoviceUserGuideTitle(), locationDetailDTO.getName()));
        normalNoviceUserGuide.setContent(String.format(this.popupProperties.getNormalNoviceUserGuideContent(), locationDetailDTO.getName()));
        HomeWindowDTO windowDTO = new HomeWindowDTO();
        windowDTO.setType(Integer.valueOf(PopTypeEnum.NORMAL_GUIDE_POP.getType()));
        windowDTO.setNormalNoviceUserGuide(normalNoviceUserGuide);
        context.setHomeWindowDTO(windowDTO);
    }

    @Override
    protected String afterIncludeVersion() {
        return "3.5.0";
    }

    @Override
    protected String beforeExcludeVersion() {
        return "3.9.0";
    }

    public NormalUserGuidePop(UserIntegrationService userIntegrationService, PopupProperties popupProperties) {
        this.userIntegrationService = userIntegrationService;
        this.popupProperties = popupProperties;
    }
}

