/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.service.pop.popinstance.impl;

import com.bxm.localnews.common.dto.LocationDetailDTO;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.thirdparty.config.PopupProperties;
import com.bxm.localnews.thirdparty.dto.HomeWindowDTO;
import com.bxm.localnews.thirdparty.dto.VipNoviceUserGuideDTO;
import com.bxm.localnews.thirdparty.param.HomeWindowParam;
import com.bxm.localnews.thirdparty.service.pop.PopTypeEnum;
import com.bxm.localnews.thirdparty.service.pop.popinstance.PopContext;
import com.bxm.localnews.thirdparty.service.pop.popinstance.impl.AbstractGuidePopup;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class VipUserGuidePop
extends AbstractGuidePopup {
    private static final Logger log = LoggerFactory.getLogger(VipUserGuidePop.class);
    private final UserIntegrationService userIntegrationService;
    private final PopupProperties popupProperties;

    @Override
    boolean filter(PopContext context) {
        if (!super.filter(context)) {
            return false;
        }
        HomeWindowParam param = context.getHomeWindowParam();
        LocationDetailDTO locationDetailDTO = (LocationDetailDTO)context.getParam("LOCATION_DETAIL_DTO");
        if (Objects.isNull(locationDetailDTO)) {
            log.warn("\u57ce\u5e02: {}\u4fe1\u606f\u83b7\u53d6\u5931\u8d25 \u8df3\u8fc7\u975evip\u7528\u6237\u7684\u5f15\u5bfc\u5f39\u7a97", (Object)param.getAreaCode());
            return false;
        }
        UserInfoDTO userInfo = this.userIntegrationService.getUserFromRedisDB(param.getUserId());
        if (Objects.isNull(userInfo)) {
            log.warn("\u7528\u6237: {} \u4e0d\u5b58\u5728\uff0c\u8df3\u8fc7vip\u7528\u6237\u7684\u5f15\u5bfc\u5f39\u7a97", (Object)param.getUserId());
            return false;
        }
        if (!this.check350JudgeMarker(userInfo.getJudgeMarker())) {
            log.info("\u7528\u6237: {} \u975e\u65b0\u7248\u672c\u7528\u6237 \u589e\u52a0\u5f39\u51fa\u7f13\u5b58\uff0c\u6c38\u4e0d\u5f39\u51fa", (Object)param.getUserId());
            super.closeCache(context);
            return false;
        }
        if (Objects.isNull(userInfo.getInviteUserId())) {
            log.info("\u7528\u6237: {} \u975e\u9080\u8bf7VIP\u7528\u6237 \u589e\u52a0\u5f39\u51fa\u7f13\u5b58\uff0c\u6c38\u4e0d\u5f39\u51fa", (Object)param.getUserId());
            super.closeCache(context);
            return false;
        }
        if (!this.isInviteVip(userInfo)) {
            log.info("\u7528\u6237: {}\u975e\u6fc0\u6d3b\u9080\u8bf7\u7684VIP \u589e\u52a0VIP\u65b0\u7528\u6237\u5f39\u7a97\u7684\u5f39\u51fa\u7f13\u5b58\uff0c\u6c38\u4e0d\u5f39\u51fa", (Object)param.getUserId());
            super.closeCache(context);
            return false;
        }
        String nickName = "";
        UserInfoDTO superInfo = this.userIntegrationService.getUserFromRedisDB(userInfo.getInviteUserId());
        if (Objects.isNull(superInfo)) {
            log.warn("\u7528\u6237: {} \u4e0a\u7ea7\u7528\u6237\u7528\u6237: {} \u4e0d\u5b58\u5728\uff0c\u5f39\u7a97\u6570\u636e\u7f3a\u5931", (Object)param.getUserId(), (Object)userInfo.getInviteUserId());
        } else {
            nickName = superInfo.getNickname();
        }
        VipNoviceUserGuideDTO guideDTO = new VipNoviceUserGuideDTO();
        guideDTO.setUserId(param.getUserId());
        guideDTO.setImgUrl(userInfo.getHeadImg());
        guideDTO.setNickName(StringUtils.join((Object[])new String[]{"\u60a8\u7684\u597d\u53cb", nickName}));
        guideDTO.setContent(String.format(this.popupProperties.getVipNoviceUserGuideContent(), locationDetailDTO.getName()));
        HomeWindowDTO windowDTO = new HomeWindowDTO();
        windowDTO.setType(Integer.valueOf(PopTypeEnum.VIP_GUIDE_POP.getType()));
        windowDTO.setVipNoviceUserGuide(guideDTO);
        context.setHomeWindowDTO(windowDTO);
        return true;
    }

    @Override
    protected String afterIncludeVersion() {
        return "3.5.0";
    }

    @Override
    protected String beforeExcludeVersion() {
        return "";
    }

    public VipUserGuidePop(UserIntegrationService userIntegrationService, PopupProperties popupProperties) {
        this.userIntegrationService = userIntegrationService;
        this.popupProperties = popupProperties;
    }
}

