/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.service.pop.popstrategy.impl;

import com.bxm.localnews.thirdparty.service.pop.popinstance.PopCache;
import com.bxm.localnews.thirdparty.service.pop.popinstance.PopContext;
import com.bxm.localnews.thirdparty.service.pop.popstrategy.impl.AbstractPopStrategy;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DaysApartStrategy
extends AbstractPopStrategy {
    private static final Logger log = LoggerFactory.getLogger(DaysApartStrategy.class);
    public static final String LAST_MODIFY_TIME = "lastModifyTime";
    @Autowired
    private RedisHashMapAdapter redisHashMapAdapter;

    @Override
    public boolean judge(PopContext popContext) {
        PopCache cache;
        String subKey = (String)popContext.getParam("key");
        Integer dayNum = (Integer)popContext.getParam("dayNum");
        if (null == dayNum) {
            dayNum = 7;
        }
        if (Objects.nonNull(cache = popContext.getCacheMap().get(subKey)) && !cache.isPopUp()) {
            return Boolean.FALSE;
        }
        if (Objects.isNull(cache)) {
            popContext.getCacheMap().put(subKey, new PopCache());
            return Boolean.TRUE;
        }
        Long dayTime = (Long)cache.getParam(LAST_MODIFY_TIME);
        return System.currentTimeMillis() - dayTime > (long)dayNum.intValue() * 86400000L;
    }

    @Override
    public void cache(PopContext popContext) {
        String subKey = popContext.getParamMap().get("key").toString();
        popContext.getCacheMap().get(subKey).addParam(LAST_MODIFY_TIME, System.currentTimeMillis());
        this.redisHashMapAdapter.put(DaysApartStrategy.getRedisKey(popContext.getHomeWindowParam().getUserId()), subKey, (Object)popContext.getCacheMap().get(subKey));
    }
}

