/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.service.wx.focus.handler;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.integration.UserAuthIntegrationService;
import com.bxm.localnews.integration.WxOfficialAccountService;
import com.bxm.localnews.thirdparty.config.WechatMPConfig;
import com.bxm.localnews.thirdparty.domain.WxOfficialLogMapper;
import com.bxm.localnews.thirdparty.vo.WxOfficialLog;
import java.util.Date;
import java.util.Objects;
import me.chanjar.weixin.mp.api.WxMpUserService;
import me.chanjar.weixin.mp.bean.result.WxMpUser;
import me.chanjar.weixin.mp.util.WxMpConfigStorageHolder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AbstractWxMpMessageHandler {
    private static final Logger log = LoggerFactory.getLogger(AbstractWxMpMessageHandler.class);
    @Autowired
    private WxMpUserService wxMpUserService;
    @Autowired
    private WxOfficialAccountService wxOfficialAccountService;
    @Autowired
    private UserAuthIntegrationService userAuthIntegrationService;
    @Autowired
    private WxOfficialLogMapper wxOfficialLogMapper;
    @Autowired
    protected WechatMPConfig wechatMPConfig;

    WxMpUser getWxMpUserByOpenId(String openId, String appId) {
        try {
            WxMpConfigStorageHolder.set((String)appId);
            WxMpUser wxMpUser = this.wxMpUserService.userInfo(openId);
            log.info("openID: {} \u5bf9\u5e94\u7684wx\u7528\u6237\u4fe1\u606f: {}", (Object)openId, JSON.toJSON((Object)wxMpUser));
            if (Objects.isNull(wxMpUser) || StringUtils.isBlank((CharSequence)wxMpUser.getUnionId())) {
                log.warn("openId: {} \u83b7\u53d6\u5fae\u4fe1\u7528\u6237\u4fe1\u606f\u5931\u8d25", (Object)openId);
                return null;
            }
            return wxMpUser;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25, openId: {}", (Object)openId, (Object)e);
            return null;
        }
    }

    void focusOnOfficialAccount(String openId, int status, String event, String appId) {
        String unionId;
        WxMpUser wxMpUser = this.getWxMpUserByOpenId(openId, appId);
        String string = unionId = wxMpUser == null ? "" : wxMpUser.getUnionId();
        if (status == 1 && null == wxMpUser) {
            log.warn("\u7528\u5fae\u4fe1openId\u83b7\u53d6userId\u5931\u8d25, openId:{}", (Object)openId);
            WxOfficialLog wxOfficialLog = new WxOfficialLog(unionId, openId, event, new Date());
            this.wxOfficialLogMapper.insertSelective(wxOfficialLog);
            return;
        }
        WxOfficialLog wxOfficialLog = new WxOfficialLog(unionId, openId, event, new Date());
        this.wxOfficialLogMapper.insertSelective(wxOfficialLog);
        this.wxOfficialAccountService.focusOnOfficialAccount(openId, unionId, appId, Integer.valueOf(status));
    }
}

