/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.timer;

import com.bxm.localnews.common.rediskey.ShortUrlRedisKey;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.bxm.newidea.component.tools.DateUtils;
import com.xxl.job.core.biz.model.ReturnT;
import java.util.Date;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HitedShortKeyRenewalTask
extends AbstractCronTask<String> {
    private static final Logger log = LoggerFactory.getLogger(HitedShortKeyRenewalTask.class);
    @Autowired
    private RedisStringAdapter redisStringAdapter;
    @Autowired
    private RedisSetAdapter redisSetAdapter;
    private static final long EXPIRE_SEC = 7776000L;

    protected ReturnT<String> service(String s) {
        log.info("\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\u6267\u884c: \u6bcf\u5929\u5c06\u524d\u4e00\u5929\u88ab\u8bbf\u95ee\u8fc7\u7684\u77ed\u94fe\u5931\u6548\u65f6\u95f4\u5ef6\u957f");
        Date yesterday = DateUtils.addField((Date)new Date(), (int)5, (int)-1);
        KeyGenerator key = ShortUrlRedisKey.SHORT_URL_HIT_KEY.copy().appendKey((Object)DateUtils.formatDate((Date)yesterday));
        Set hotKeys = this.redisSetAdapter.getAllMembers(key, String.class);
        hotKeys.forEach(p -> {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("\u7f13\u5b58key: {} \u6628\u65e5\u88ab\u8bbf\u95ee\u8fc7\uff0c\u5ef6\u8fdf\u5931\u6548", p);
                }
                this.redisStringAdapter.expire(ShortUrlRedisKey.SHORT_URL.copy().appendKey(p), 7776000L);
            }
            catch (Exception e) {
                log.error("\u7f13\u5b58key: {} \u5ef6\u8fdf\u65f6\u95f4\u65f6\u95f4\u5931\u8d25", p, (Object)e);
            }
        });
        this.redisSetAdapter.remove(key);
        log.info("\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f\u6267\u884c: \u6bcf\u5929\u5c06\u524d\u4e00\u5929\u88ab\u8bbf\u95ee\u8fc7\u7684\u77ed\u94fe\u5931\u6548\u65f6\u95f4\u5ef6\u957f");
        return ReturnT.SUCCESS;
    }

    public String taskName() {
        return "HitedShortKeyRenewalTask";
    }

    public String cron() {
        return "0 5 0 * * ?";
    }

    public String description() {
        return "\u6bcf\u5929\u5c06\u524d\u4e00\u5929\u88ab\u8bbf\u95ee\u8fc7\u7684\u77ed\u94fe\u5931\u6548\u65f6\u95f4\u5ef6\u957f";
    }
}

