package com.bxm.localnews.user.controller;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Map;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.common.vo.SmsJson;
import com.bxm.localnews.mq.common.constant.SmsTemplateEnum;
import com.bxm.localnews.mq.common.model.dto.SendSmsResult;
import com.bxm.localnews.mq.common.model.dto.SmsSupplyDTO;
import com.bxm.localnews.user.adapter.ParamAdapter;
import com.bxm.localnews.user.config.BizConfigProperties;
import com.bxm.localnews.user.config.UserProperties;
import com.bxm.localnews.user.constant.RedisConfig;
import com.bxm.localnews.user.dto.*;
import com.bxm.localnews.user.integration.SmsIntegrationService;
import com.bxm.localnews.user.param.*;
import com.bxm.localnews.user.service.UserBaseInfoService;
import com.bxm.localnews.user.service.UserInternalService;
import com.bxm.localnews.user.service.UserService;
import com.bxm.localnews.user.vo.H5RegisterParam;
import com.bxm.localnews.user.vo.LoginInfo;
import com.bxm.localnews.user.vo.LoginMeta;
import com.bxm.localnews.user.vo.User;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.enums.FileTypeEnum;
import com.bxm.newidea.component.oss.config.AliyunOssProperties;
import com.bxm.newidea.component.oss.service.AliyunOSSService;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.FileUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.tools.Validater;
import com.bxm.newidea.component.util.WebUtils;
import com.bxm.newidea.component.vo.Message;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.*;

import static com.bxm.localnews.common.constant.RespCode.BAD_REQUEST;

@Api(tags = "9-02 用户注册", description = "用户注册和管理")
@RestController
@RequestMapping("api/user")
@RefreshScope
public class UserController extends BaseController {

    @Resource
    private UserService userService;

    @Resource
    private UserInternalService userInternalService;

    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;

    @Resource
    private SmsIntegrationService smsIntegrationService;

    @Resource
    private BizConfigProperties bizConfigProperties;

    @Resource
    private UserProperties userProperties;

    @Resource
    private AliyunOssProperties aliyunOssProperties;

    @Resource
    private AliyunOSSService aliyunOSSService;

    @Resource
    private UserBaseInfoService userBaseInfoService;

    @ApiOperation(value = "9-02-1 静默注册", notes = "用户打开app，不存在userId,根据设备号来返回该手机游客模式的userId")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "platform", value = "平台信息 1：安卓 2：IOS 3：H5", allowableValues = "1,2,3"),
            @ApiImplicitParam(name = "chnl", value = "渠道信息 具体查看C_CHANNEL表或找[赵亚东]"),
            @ApiImplicitParam(name = "firstOpenType", value = "是否是第一次打开应用，1：首次打开"),
    })
    @RequestMapping(value = "toRegister", method = RequestMethod.POST)
    public Json<LoginMeta> register(SilentRegisterParam registerParam, BasicParam basicParam, String firstOpenType, HttpServletRequest request) {
        LoginInfo loginInfo = ParamAdapter.transformSilentRegisterToLoginInfo(registerParam);
        loginInfo.setRegIp(WebUtils.getIpAddr(request));
        //这个方法使用的是LoginInfo的类，但是现在要用别的类了，所以需要使用适配器模式
        return this.userService.register(loginInfo, basicParam, firstOpenType);
    }

    @ApiOperation(value = "9-02-2 普通h5页面注册", notes = "只是简单的提供手机号验证码密码登录")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "platform", value = "平台信息 1：安卓 2：IOS 3：H5", allowableValues = "1,2,3", required = true),
            @ApiImplicitParam(name = "chnl", value = "渠道信息 具体查看C_CHANNEL表或找[赵亚东]")
    })
    @RequestMapping(value = "/H5/toRegister", method = RequestMethod.POST)
    public Json<User> h5Register(H5RegisterParam registerParam, Integer platform, String chnl, HttpServletRequest request) {
        LoginInfo loginInfo = ParamAdapter.transformH5Register(registerParam);
        loginInfo.setRegIp(WebUtils.getIpAddr(request));
        return this.userService.doH5Register(loginInfo, platform, chnl);
    }

    @ApiOperation(value = "9-02-3 重置用户token", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id"),
            @ApiImplicitParam(name = "refreshToken", value = "刷新的token")
    })
    @RequestMapping(value = "refreshToken", method = RequestMethod.POST)
    public Json<UserInfoDTO> refreshToken(@RequestParam(value = "userId") long userId,
                                          @RequestParam(value = "refreshToken") String refreshToken) {
        return this.userService.refreshToken(userId, refreshToken);
    }

    @ApiOperation(value = "9-02-4 获取绑定手机号码的验证码", notes = "")
    @ApiImplicitParam(name = "phone", value = "手机号")
    @PostMapping("getBindPhoneCode")
    public SmsJson getVerificationCode(String phone, HttpServletRequest httpServletRequest) {
        if (!Validater.checkPhone(phone)) {
            return SmsJson.build(ResultUtil.genFailedResult(BAD_REQUEST, "手机号码格式错误"));
        }
        SmsSupplyDTO smsSupplyDTO = new SmsSupplyDTO();
        smsSupplyDTO.setPhoneNo(phone);
        smsSupplyDTO.setSmsTemplateEnum(SmsTemplateEnum.BINDING_PHONE);
        smsSupplyDTO.setIp(WebUtils.getIpAddr(httpServletRequest));
        SendSmsResult result = this.smsIntegrationService.sendSmsByVCodeTemplate(smsSupplyDTO);
        int respCode = 0;
        if (result.getState()) {
            respCode = RespCode.OK;
        } else {
            respCode = BAD_REQUEST;
        }
        return SmsJson.build(ResultUtil.genFailedResult(respCode, result.getMsg()));
    }

    @ApiOperation(value = "9-02-5 退出登录", notes = "")
    @ApiImplicitParam(name = "userId", value = "用户ID")
    @GetMapping(value = "logout")
    public Json logout(Long userId) {
//        // 清空用户redis信息
//        this.redisHashMapAdapter.remove(RedisConfig.USER_INFO, userId.toString());
//        // 将token 设置过期
//        this.userService.updateUserTokenExpireTime(userId);
        return ResultUtil.genSuccessResult();
    }

    @ApiOperation(value = "9-02-6 绑定三方账号", notes = "")
    @ApiImplicitParam(name = "userId", value = "用户ID")
    @RequestMapping(value = "bindingAccount", method = RequestMethod.POST)
    public Json<UserInfoDTO> binding(WechatBindParam wechatBindParam, Long userId) {
        LoginInfo loginInfo = ParamAdapter.transformWechatBindToLoginInfo(wechatBindParam);
        return this.userService.binding(loginInfo, userId);
    }

    @ApiOperation(value = "9-02-10 获取用户基本信息", notes = "包含 头像、昵称、性别、生日、地址、兴趣")
    @ApiImplicitParam(name = "userId", value = "用户ID")
    @RequestMapping(value = "getUserBaseInfo", method = RequestMethod.GET)
    public Json<UserInfoDTO> getUserBaseInfo(@RequestParam(value = "userId") long userId) {
        return ResultUtil.genSuccessResult(this.userService.getUserFromRedisDB(userId));
    }

    @ApiOperation(value = "9-02-11 更新用户信息", notes = "目前支持 性别、生日、地址、昵称、头像")
    @ApiImplicitParam(name = "userId", value = "用户ID")
    @RequestMapping(value = "updateUserInfo", method = RequestMethod.POST)
    public Json updateUserInfo(UserParam user) {
        Message message = this.userService.updateUserInfo(user, user.getUserId(), user.getFile());
        if (message.isSuccess()) {
            Map<String, Object> paramMap = message.getParamMap();
            UserInfoDTO userInfoDTO = (UserInfoDTO) paramMap.get("user");
            return ResultUtil.genSuccessResult(userInfoDTO);
        }
        return Json.build(message);
    }

    @ApiOperation(value = "9-02-12 获取用户支付token", notes = "获取用户的支付token，有效期为一个小时")
    @ApiImplicitParam(name = "userId", value = "用户ID", required = true)
    @PostMapping(value = "getPayToken")
    public Json<PayToken> getPayToken(Long userId) {
        String token = this.userService.getToken();
        return ResultUtil.genSuccessResult(new PayToken(token));
    }

    @ApiOperation(value = "9-02-13 获取用户推广链接（包含用户邀请码）")
    @ApiImplicitParam(name = "userId", value = "用户ID", required = true)
    @RequestMapping(value = "getRegisterUrl", method = RequestMethod.POST)
    public Json<RegisterMeta> getRegisterUrl(Long userId) {
        String channelUrl = bizConfigProperties.getChannelUrl();
        return ResultUtil.genSuccessResult(new RegisterMeta(channelUrl + userId));
    }

    @ApiOperation(value = "9-02-14 获取个人相关信息", notes = "包含姓名、头像、金币、签到信息、邀请人数")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID", required = true),
            @ApiImplicitParam(name = "platform", value = "平台信息 1：安卓 2：IOS 3：H5", allowableValues = "1,2,3", required = true),
    })
    @GetMapping(value = "getUserInfo")
    public Json<UserBaseInfoDTO> getUserInfo(@RequestParam(value = "userId") long userId,
                                             @RequestParam(value = "platform") int platform) {
//        this.userBaseInfoService.getUserInfoForWST(userId, platform);
        return ResultUtil.genSuccessResult();
    }

    @ApiOperation(value = "9-02-14 定位得到城市并更新位置", notes = "根据客户端传过来的区域编号更新用户的地理位置，并添加用户地理位置历史")
    @PostMapping(value = "/location")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID"),
            @ApiImplicitParam(name = "code", value = "地区编码")
    })
    public Json<LocationDTO> getUserLocation(@RequestParam(value = "userId", required = false) Long userId,
                                             @RequestParam(value = "code", required = false) String code) {
        logger.debug("得到城市code:{}", code);
        return ResultUtil.genSuccessResult(userInternalService.doPostingLocation(code, userId));
    }

    @ApiOperation(value = "9-02-15 获取用户头像的文件流", notes = "不再推荐调用，修改为9-2-18接口")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID", dataType = "long")
    })
    @GetMapping("/userInfo/img")
    @Deprecated
    public void getPrivilegeImg(@RequestParam(name = "userId") Long userId, HttpServletResponse response) throws IOException {
        BufferedInputStream dis = null;
        BufferedOutputStream fos = null;
        UserInfoDTO userInfoDTO = this.userService.getUserFromRedisDB(userId);
        if (userInfoDTO == null) {
            return;
        }

        String urlString = userInfoDTO.getHeadImg();
        if (StringUtils.isBlank(userInfoDTO.getHeadImg())) {
            return;
        }
        String fileName = urlString.substring(urlString.lastIndexOf('/') + 1);
        try {

            URL url = new URL(urlString);
            response.reset();//避免空行
            String contentType = FileTypeEnum.getContentType(urlString.substring(urlString.lastIndexOf('.') + 1));
            if (StringUtils.isBlank(contentType)) {
                contentType = "image/jpeg";
            }
            response.setContentType(contentType);
            response.setHeader("Content-disposition", "attachment; filename=" + new String(fileName.getBytes("utf-8"), "ISO8859-1"));
            response.setHeader("Content-Length", String.valueOf(url.openConnection().getContentLength()));

            dis = new BufferedInputStream(url.openStream());
            fos = new BufferedOutputStream(response.getOutputStream());

            byte[] buff = new byte[2048];
            int bytesRead;
            while (-1 != (bytesRead = dis.read(buff, 0, buff.length))) {
                fos.write(buff, 0, bytesRead);
            }

        } catch (Exception e) {
            logger.error(e.getMessage(), e);
        } finally {
            if (dis != null) {
                dis.close();
            }
            if (fos != null) {
                fos.close();
            }
        }

    }

    @ApiOperation(value = "9-02-16 获取手机号码是否已注册", notes = "")
    @GetMapping(value = "/userPhone")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "phone", value = "手机号")
    })
    public Json<Boolean> isUserPhone(@RequestParam(value = "phone") String phone,
                                     @RequestParam(value = "flag", required = false, defaultValue = "0") Integer flag) {
        return Json.build(userService.checkUserExistByPhone(phone, flag));
    }

    @ApiOperation(value = "9-02-17 保存用户推送信息", notes = "每个用户会保存推送的平台以及推送的token")
    @PostMapping(value = "/push")
    public Json getPushToken(PushParam pushParam) {
        if (StringUtils.isEmpty(pushParam.getPushPlatform()) ||
                StringUtils.isEmpty(pushParam.getPushToken()) ||
                null == pushParam.getUserId()) {
            return ResultUtil.genFailedResult(BAD_REQUEST, "参数错误");
        }
        userInternalService.savePush(pushParam);
        return ResultUtil.genSuccessResult();
    }

    @ApiOperation(value = "9-02-18 获取用户头像的文件流", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID", dataType = "long")
    })
    @GetMapping("/userInfo/headimg")
    public Json<String> getUserHeaderImg(@RequestParam(name = "userId") Long userId) {
        UserInfoDTO userInfoDTO = this.userService.getUserFromRedisDB(userId);
        if (userInfoDTO == null) {
            return Json.build(userProperties.getDefaultHeadImgUrl());
        }

        String urlString = userInfoDTO.getHeadImg();
        if (StringUtils.isBlank(userInfoDTO.getHeadImg())) {
            return Json.build(userProperties.getDefaultHeadImgUrl());
        }

        if (StringUtils.startsWith(urlString, aliyunOssProperties.getCdnUrl())) {
            logger.debug("hit cache headimg:{}", userId);
            return Json.build(urlString);
        }

        try {
            String fileExt = FileUtils.getFilextension(urlString);
            if (FileTypeEnum.getContentType(fileExt) == null) {
                fileExt = FileTypeEnum.JPG.getExtName();
            }
            URL url = new URL(urlString);
            BufferedInputStream dis = new BufferedInputStream(url.openStream());
            int hashCode = (int) (userId % 10);
            String imgUrl = aliyunOSSService.upload(dis, "avatar/" + hashCode + "/" + userId + "." + fileExt);

            userInfoDTO.setHeadImg(imgUrl);
            this.redisHashMapAdapter.put(RedisConfig.USER_INFO, userId + "", JSON.toJSONString(userInfoDTO));

            return Json.build(imgUrl);
        } catch (IOException e) {
            logger.error(e.getMessage(), e);
        }
        return Json.build(RespCode.BAD_REQUEST, "用户信息错误");
    }

    @ApiOperation(value = "9-02-19 获取用户基本信息", notes = "包含 头像、昵称、地址")
    @ApiImplicitParam(name = "userId", value = "用户ID")
    @RequestMapping(value = "getLocationUserInfo", method = RequestMethod.GET)
    public Json<LocationUserInfoDTO> getLocationUserInfo(@RequestParam(value = "userId") long userId) {
        return ResultUtil.genSuccessResult(this.userService.getLocationUserInfo(userId));
    }

    @ApiOperation(value = "9-02-20 创建临时用户", notes = "APP分享新闻、活动等页面通过邀请途径生成临时用户")
    @PostMapping(value = "/create/temp")
    public Json<WxUserInfo> getLocationUserInfo(TempUserParam tempUserParam, HttpServletRequest request) {
        tempUserParam.setRegIp(WebUtils.getIpAddr(request));
        Message message = userService.createUser(tempUserParam);
        return ResultUtil.genSuccessResult(getWxUserInfo((long) message.getParamMap().get("userId"), tempUserParam));
    }

    /**
     * 获取微信用户信息
     *
     * @return
     */
    private WxUserInfo getWxUserInfo(Long userId, TempUserParam tempUserParam) {
        WxUserInfo wxUserInfo = new WxUserInfo();
        wxUserInfo.setUserId(userId);
        wxUserInfo.setHeadImg(tempUserParam.getHeadImg());
        wxUserInfo.setUnionId(tempUserParam.getUnionId());
        wxUserInfo.setNickname(tempUserParam.getNickName());

        return wxUserInfo;
    }
}
