/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.controller;

import com.bxm.localnews.base.integration.DomainIntegrationService;
import com.bxm.localnews.common.constant.DomainScene;
import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.rediskey.UserRedisKey;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.attribute.UserAttributeService;
import com.bxm.localnews.user.dto.BaseUserInfo;
import com.bxm.localnews.user.dto.LocationDTO;
import com.bxm.localnews.user.dto.LocationUserInfoDTO;
import com.bxm.localnews.user.dto.PayToken;
import com.bxm.localnews.user.dto.RegisterMeta;
import com.bxm.localnews.user.dto.UserBaseInfoDTO;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.dto.WxUserInfo;
import com.bxm.localnews.user.event.LogoutActionEvent;
import com.bxm.localnews.user.login.UserRegistrationService;
import com.bxm.localnews.user.login.UserService;
import com.bxm.localnews.user.login.adapter.ParamAdapter;
import com.bxm.localnews.user.param.PushParam;
import com.bxm.localnews.user.param.SilentRegisterParam;
import com.bxm.localnews.user.param.TempUserParam;
import com.bxm.localnews.user.param.UserBindPhoneParam;
import com.bxm.localnews.user.properties.BizConfigProperties;
import com.bxm.localnews.user.support.UserInternalService;
import com.bxm.localnews.user.vo.LoginInfo;
import com.bxm.localnews.user.vo.LoginMeta;
import com.bxm.localnews.user.vo.UserBindPhoneVO;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.jwt.tools.JwtTokenUtil;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.util.WebUtils;
import com.bxm.newidea.component.vo.Message;
import com.google.common.eventbus.EventBus;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"9-02 \u7528\u6237\u76f8\u5173API"}, description="\u7528\u6237\u6ce8\u518c\u548c\u7ba1\u7406")
@RestController
@RequestMapping(value={"api/user"})
@RefreshScope
public class UserController
extends BaseController {
    @Resource
    private UserService userService;
    @Resource
    private UserRegistrationService userRegistrationService;
    @Resource
    private UserInternalService userInternalService;
    @Resource
    private BizConfigProperties bizConfigProperties;
    @Resource
    private UserAttributeService userAttributeService;
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;
    @Resource
    private DomainIntegrationService domainIntegrationService;
    @Resource
    private EventBus userActionEventBus;

    @ApiOperation(value="9-02-1 \u9759\u9ed8\u6ce8\u518c", notes="\u7528\u6237\u6253\u5f00app\uff0c\u4e0d\u5b58\u5728userId,\u6839\u636e\u8bbe\u5907\u53f7\u6765\u8fd4\u56de\u8be5\u624b\u673a\u6e38\u5ba2\u6a21\u5f0f\u7684userId")
    @ApiImplicitParams(value={@ApiImplicitParam(name="platform", value="\u5e73\u53f0\u4fe1\u606f 1\uff1a\u5b89\u5353 2\uff1aIOS 3\uff1aH5", allowableValues="1,2,3"), @ApiImplicitParam(name="chnl", value="\u6e20\u9053\u4fe1\u606f \u5177\u4f53\u67e5\u770bC_CHANNEL\u8868\u6216\u627e[\u8d75\u4e9a\u4e1c]"), @ApiImplicitParam(name="firstOpenType", value="\u662f\u5426\u662f\u7b2c\u4e00\u6b21\u6253\u5f00\u5e94\u7528\uff0c1\uff1a\u9996\u6b21\u6253\u5f00")})
    @RequestMapping(value={"toRegister"}, method={RequestMethod.POST})
    public Json<LoginMeta> register(SilentRegisterParam registerParam, BasicParam basicParam, String firstOpenType, HttpServletRequest request) {
        LoginInfo loginInfo = ParamAdapter.transformSilentRegisterToLoginInfo((SilentRegisterParam)registerParam);
        loginInfo.setRegIp(WebUtils.getIpAddr((HttpServletRequest)request));
        return this.userRegistrationService.register(loginInfo, basicParam, firstOpenType);
    }

    @ApiOperation(value="9-02-3 \u91cd\u7f6e\u7528\u6237token")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id"), @ApiImplicitParam(name="refreshToken", value="\u5237\u65b0\u7684token")})
    @RequestMapping(value={"refreshToken"}, method={RequestMethod.POST})
    public Json<UserInfoDTO> refreshToken(@RequestParam(value="userId") long userId, @RequestParam(value="refreshToken") String refreshToken) {
        return this.userService.refreshToken(Long.valueOf(userId), refreshToken);
    }

    @ApiOperation(value="9-02-5 \u9000\u51fa\u767b\u5f55")
    @ApiImplicitParam(name="userId", value="\u7528\u6237ID")
    @GetMapping(value={"logout"})
    public Json logout(Long userId) {
        this.userService.removeUserCache(userId);
        this.redisHashMapAdapter.remove(UserRedisKey.HASH_USER_TOKEN, new String[]{String.valueOf(userId)});
        this.userActionEventBus.post((Object)LogoutActionEvent.of().setUserId(userId));
        return ResultUtil.genSuccessResult();
    }

    @ApiOperation(value="9-02-12 \u83b7\u53d6\u7528\u6237\u652f\u4ed8token", notes="\u83b7\u53d6\u7528\u6237\u7684\u652f\u4ed8token\uff0c\u6709\u6548\u671f\u4e3a\u4e00\u4e2a\u5c0f\u65f6")
    @ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true)
    @PostMapping(value={"getPayToken"})
    public Json<PayToken> getPayToken(Long userId) {
        String token = JwtTokenUtil.generateToken((Long)userId);
        return ResultUtil.genSuccessResult((Object)new PayToken(token));
    }

    @ApiOperation(value="9-02-13 \u83b7\u53d6\u7528\u6237\u63a8\u5e7f\u94fe\u63a5\uff08\u5305\u542b\u7528\u6237\u9080\u8bf7\u7801\uff09")
    @ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true)
    @RequestMapping(value={"getRegisterUrl"}, method={RequestMethod.POST})
    public Json<RegisterMeta> getRegisterUrl(Long userId) {
        return ResultUtil.genSuccessResult((Object)new RegisterMeta(StringUtils.join((Object[])new Serializable[]{this.domainIntegrationService.getOutSideShareBaseUrl(DomainScene.DomainViewScene.CONTENT_VIEW), this.bizConfigProperties.getChannelPath(), userId})));
    }

    @ApiOperation(value="9-02-14 \u7528\u6237\u5207\u6362\u57ce\u5e02\u5e76\u66f4\u65b0\u4f4d\u7f6e", notes="\u6839\u636e\u5ba2\u6237\u7aef\u4f20\u8fc7\u6765\u7684\u533a\u57df\u7f16\u53f7\u66f4\u65b0\u7528\u6237\u7684\u5730\u7406\u4f4d\u7f6e\uff0c\u5e76\u6dfb\u52a0\u7528\u6237\u5730\u7406\u4f4d\u7f6e\u5386\u53f2\uff0c\u5728\u6bcf\u6b21\u542f\u52a8app\u540e\u8c03\u7528")
    @PostMapping(value={"/location"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID"), @ApiImplicitParam(name="code", value="\u5730\u533a\u7f16\u7801")})
    public Json<LocationDTO> getUserLocation(@RequestParam(value="userId", required=false) Long userId, @RequestParam(value="code", required=false) String code, BasicParam basicParam, HttpServletRequest request) {
        String ip = WebUtils.getIpAddr((HttpServletRequest)request);
        return ResultUtil.genSuccessResult((Object)this.userInternalService.doPostingLocation(code, userId, basicParam, ip));
    }

    @ApiOperation(value="9-02-16 \u83b7\u53d6\u624b\u673a\u53f7\u7801\u662f\u5426\u5df2\u6ce8\u518c")
    @GetMapping(value={"/userPhone"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="phone", value="\u624b\u673a\u53f7")})
    public Json<Boolean> isUserPhone(@RequestParam(value="phone") String phone, @RequestParam(value="flag", required=false, defaultValue="0") Integer flag) {
        return Json.build((Object)this.userService.checkUserExistByPhone(phone, flag));
    }

    @ApiOperation(value="9-02-17 \u4fdd\u5b58\u7528\u6237\u63a8\u9001\u4fe1\u606f", notes="\u6bcf\u4e2a\u7528\u6237\u4f1a\u4fdd\u5b58\u63a8\u9001\u7684\u5e73\u53f0\u4ee5\u53ca\u63a8\u9001\u7684token")
    @PostMapping(value={"/push"})
    public Json getPushToken(PushParam pushParam) {
        if (com.bxm.newidea.component.tools.StringUtils.isEmpty((CharSequence)pushParam.getPushPlatform()) || com.bxm.newidea.component.tools.StringUtils.isEmpty((CharSequence)pushParam.getPushToken()) || null == pushParam.getUserId()) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u53c2\u6570\u9519\u8bef");
        }
        this.userAttributeService.savePush(pushParam);
        return ResultUtil.genSuccessResult();
    }

    @ApiOperation(value="9-02-18 \u83b7\u53d6\u7528\u6237\u5934\u50cf\u7684\u6587\u4ef6\u5730\u5740", notes="\u4e3a\u89e3\u51b3\u5ba2\u6237\u7aef\u8bf7\u6c42\u5fae\u4fe1\u56fe\u7247\u8de8\u57df\u95ee\u9898")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", dataType="long")})
    @GetMapping(value={"/userInfo/headimg"})
    public Json<String> getUserHeaderImg(@RequestParam(name="userId") Long userId) {
        String fileInputStream = this.userInternalService.getUserHeaderImg(userId);
        if (null == fileInputStream) {
            return Json.build((int)RespCode.BAD_REQUEST, (String)"\u83b7\u53d6\u7528\u6237\u5934\u50cf\u6587\u4ef6\u6d41\u9519\u8bef");
        }
        return Json.build((Object)fileInputStream);
    }

    @ApiOperation(value="9-02-19 \u83b7\u53d6\u7528\u6237\u57fa\u672c\u4fe1\u606f", notes="\u5305\u542b \u5934\u50cf\u3001\u6635\u79f0\u3001\u5730\u5740")
    @ApiImplicitParam(name="userId", value="\u7528\u6237ID")
    @RequestMapping(value={"getLocationUserInfo"}, method={RequestMethod.GET})
    public Json<LocationUserInfoDTO> getLocationUserInfo(@RequestParam(value="userId", required=false) Long userId) {
        if (Objects.isNull(userId)) {
            userId = 0L;
        }
        return ResultUtil.genSuccessResult((Object)this.userService.getLocationUserInfo(userId));
    }

    @ApiOperation(value="9-02-20 \u521b\u5efa\u4e34\u65f6\u7528\u6237", notes="APP\u5206\u4eab\u65b0\u95fb\u3001\u6d3b\u52a8\u7b49\u9875\u9762\u901a\u8fc7\u9080\u8bf7\u9014\u5f84\u751f\u6210\u4e34\u65f6\u7528\u6237")
    @PostMapping(value={"/create/temp"})
    public Json<WxUserInfo> createTempUser(TempUserParam tempUserParam, HttpServletRequest request) {
        tempUserParam.setRegIp(WebUtils.getIpAddr((HttpServletRequest)request));
        Message message = this.userService.getWxUserInfo(tempUserParam, request);
        if (message.isSuccess()) {
            return ResultUtil.genSuccessResult((Object)message.getParam("wxUserInfo"));
        }
        return ResultUtil.genFailedResult((String)message.getLastMessage());
    }

    @ApiOperation(value="9-02-22 \u83b7\u53d6\u7528\u6237\u5934\u50cf\u3001\u6635\u79f0")
    @ApiImplicitParam(name="currentUserId", value="\u7528\u6237ID")
    @RequestMapping(value={"getNickNameAndHeadImg"}, method={RequestMethod.GET})
    public Json<BaseUserInfo> getUserBaseInfo(@RequestParam(value="currentUserId") Long currentUserId) {
        return ResultUtil.genSuccessResult((Object)this.userService.getNickNameAndHeadImg(currentUserId));
    }

    @ApiOperation(value="9-02-23 \u3010\u6211\u7684\u3011\u83b7\u53d6\u4e2a\u4eba\u76f8\u5173\u4fe1\u606f", notes="\u5305\u542b\u59d3\u540d\u3001\u5934\u50cf\u3001\u91d1\u5e01\u3001\u7b7e\u5230\u4fe1\u606f\u3001\u9080\u8bf7\u4eba\u6570")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true), @ApiImplicitParam(name="platform", value="\u5e73\u53f0\u4fe1\u606f 1\uff1a\u5b89\u5353 2\uff1aIOS 3\uff1aH5", allowableValues="1,2,3", required=true)})
    @GetMapping(value={"getUserInfo"})
    public Json<UserBaseInfoDTO> getUserInfo(@RequestParam(value="userId") long userId, @RequestParam(value="platform") int platform) {
        return ResultUtil.genSuccessResult((Object)this.userInternalService.getUserPersonalCenterInfo(Long.valueOf(userId), platform));
    }

    @ApiOperation(value="9-02-24 \u7ad9\u5916\u6821\u9a8c\u662f\u5426\u7ed1\u5b9a\u624b\u673a\u53f7", notes="\u53ea\u6709userId \u5c31\u6821\u9a8c\u662f\u5426\u5df2\u7ecf\u7ed1\u5b9a\uff0c\u53ea\u6709phone\uff0c\u5c31\u6821\u9a8c\u662f\u5426\u5df2\u7ecf\u4f7f\u7528,true:\u53ef\u4ee5\u4f7f\u7528 \uff0cfasle\u4e0d\u53ef\u4ee5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID"), @ApiImplicitParam(name="phone", value="\u624b\u673a\u53f7\u7801")})
    @GetMapping(value={"/public/checkHasBindPhone"})
    public Json<UserBindPhoneVO> publicCheckHasBindPhone(@RequestParam String phone, @RequestParam Long userId) {
        return ResultUtil.genSuccessResult((Object)this.userService.checkUserAndPhoneExists(UserBindPhoneParam.builder().phone(phone).userId(userId).build()));
    }

    @ApiOperation(value="9-02-25 \u6821\u9a8c\u662f\u5426\u7ed1\u5b9a\u624b\u673a\u53f7", notes="\u7ad9\u5185\u7528\u6765\u6821\u9a8c\u662f\u5426\u7ed1\u5b9a\u624b\u673a\u53f7\u7801")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID"), @ApiImplicitParam(name="phone", value="\u624b\u673a\u53f7\u7801")})
    @GetMapping(value={"/checkHasBindPhone"})
    public Json<UserBindPhoneVO> checkHasBindPhone(@RequestParam String phone, @RequestParam Long userId) {
        return ResultUtil.genSuccessResult((Object)this.userService.checkUserAndPhoneExists(UserBindPhoneParam.builder().phone(phone).userId(userId).build()));
    }

    @ApiOperation(value="9-02-26 \u7ad9\u5916\u7ed1\u5b9a\u624b\u673a\u53f7", notes="\u7ad9\u5916\u7ed1\u5b9a\u624b\u673a\u53f7")
    @PostMapping(value={"/public/bindUserPhone"})
    public Json<UserBindPhoneVO> publicBindUserPhone(@RequestBody UserBindPhoneParam userBindPhoneParam) {
        return ResultUtil.genSuccessResult((Object)this.userService.bindUserPhone(userBindPhoneParam));
    }

    @ApiOperation(value="9-02-27 \u7ad9\u5185\u7ed1\u5b9a\u624b\u673a\u53f7", notes="\u7ed1\u5b9a\u624b\u673a\u53f7")
    @PostMapping(value={"/bindUserPhone"})
    public Json<UserBindPhoneVO> bindUserPhone(@RequestBody UserBindPhoneParam userBindPhoneParam) {
        return ResultUtil.genSuccessResult((Object)this.userService.bindUserPhone(userBindPhoneParam));
    }
}

