/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.controller;

import com.bxm.localnews.user.dto.vip.VipActivationResultDTO;
import com.bxm.localnews.user.model.VipCardInfoDTO;
import com.bxm.localnews.user.model.VipInfoDetailDTO;
import com.bxm.localnews.user.model.param.VipQueryParam;
import com.bxm.localnews.user.param.VipActivationCodeParam;
import com.bxm.localnews.user.vip.UserVipService;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"{version}/user/vipInfo"})
@Api(tags={"9-21 [v1]\u4f1a\u5458\u5361\u76f8\u5173\u4fe1\u606fAPI"}, description="\u4f1a\u5458\u5361\u7684\u76f8\u5173\u4fe1\u606f")
public class VipUserController {
    private final UserVipService userVipService;

    @Autowired
    public VipUserController(UserVipService userVipService) {
        this.userVipService = userVipService;
    }

    @ApiOperation(value="9-21-01 [v1]\u4f1a\u5458\u5361\u4fe1\u606f\u5217\u8868", notes="\u67e5\u8be2\u914d\u7f6e\u7684\u4f1a\u5458\u5361\u4fe1\u606f\u5217\u8868")
    @RequestMapping(value={"vipCard"}, method={RequestMethod.GET})
    @ApiVersion(value=1)
    public ResponseJson<List<VipCardInfoDTO>> getVipCard() {
        return ResponseJson.ok((Object)this.userVipService.getVipCardList());
    }

    @ApiOperation(value="9-21-02 [v1]\u6fc0\u6d3b\u7801\u6fc0\u6d3bVIP", notes="\u5982\u679c\u8fd4\u56decode\u4e0d\u7b49\u4e8e200\uff0c\u5219\u663e\u793a\u5bf9\u4e8e\u7684\u9519\u8bef\u63d0\u793a\u4fe1\u606f")
    @RequestMapping(value={"vipActivation"}, method={RequestMethod.POST})
    @ApiVersion(value=1)
    public ResponseJson<VipActivationResultDTO> vipActivation(@RequestBody VipActivationCodeParam activationCodeParam) {
        return ResponseJson.ok((Object)this.userVipService.execActivationVipByCode(activationCodeParam, Integer.valueOf(0)));
    }

    @ApiOperation(value="9-21-03 [v1]\u6fc0\u6d3b\u7801\u6fc0\u6d3bVIP\uff0c\u7ad9\u5916\u4f7f\u7528", notes="\u5982\u679c\u8fd4\u56decode\u4e0d\u7b49\u4e8e200\uff0c\u5219\u663e\u793a\u5bf9\u4e8e\u7684\u9519\u8bef\u63d0\u793a\u4fe1\u606f")
    @RequestMapping(value={"public/vipActivation"}, method={RequestMethod.POST})
    @ApiVersion(value=1)
    public ResponseJson<VipActivationResultDTO> vipActivationPublic(@RequestBody VipActivationCodeParam activationCodeParam) {
        return ResponseJson.ok((Object)this.userVipService.execActivationVipByCode(activationCodeParam, Integer.valueOf(1)));
    }

    @ApiOperation(value="9-21-04 [v1]\u7ad9\u5916\u4f1a\u5458\u5361\u4fe1\u606f\u5217\u8868", notes="\u67e5\u8be2\u914d\u7f6e\u7684\u4f1a\u5458\u5361\u4fe1\u606f\u5217\u8868")
    @RequestMapping(value={"/public/vipCard"}, method={RequestMethod.GET})
    @ApiVersion(value=1)
    public ResponseJson<List<VipCardInfoDTO>> getVipCardPublic() {
        return ResponseJson.ok((Object)this.userVipService.getVipCardList());
    }

    @ApiOperation(value="9-21-05 [v2]\u7ad9\u5185\u83b7\u53d6VIP\u4fe1\u606f", notes="\u7ad9\u5185\u83b7\u53d6VIP\u4fe1\u606f")
    @RequestMapping(value={"/vipDetail"}, method={RequestMethod.GET})
    @ApiVersion(value=2)
    public ResponseJson<VipInfoDetailDTO> get(VipQueryParam param) {
        return ResponseJson.ok((Object)this.userVipService.getVipDetail(param));
    }

    @ApiOperation(value="9-21-05 [v1]\u7ad9\u5185\u83b7\u53d6VIP\u4fe1\u606f", notes="\u7ad9\u5185\u83b7\u53d6VIP\u4fe1\u606f", hidden=true)
    @RequestMapping(value={"/vipDetail"}, method={RequestMethod.GET})
    @ApiVersion(value=1)
    public ResponseJson<VipInfoDetailDTO> getVipCardPublic(@RequestParam(value="userId") Long userId) {
        VipQueryParam param = new VipQueryParam();
        param.setUserId(userId);
        return ResponseJson.ok((Object)this.userVipService.getVipDetail(param));
    }
}

