package com.bxm.localnews.user.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * 通用的业务配置，具体模块的配置需要在对应的模块内创建properties和特定的前缀接收
 *
 * @author liujia 2018/7/26 16:45
 */
@Component
@ConfigurationProperties("common.config")
public class BizConfigProperties {

    /**
     * api签名加密密钥
     */
    private String apiSignKey;

    /**
     * 推广渠道链接H5地址
     */
    private String channelUrl;

    /**
     * 区域编码
     */
    private String locationCode;

    /**
     * 区域名称
     */
    private String locationName;

    public String getApiSignKey() {
        return apiSignKey;
    }

    public void setApiSignKey(String apiSignKey) {
        this.apiSignKey = apiSignKey;
    }

    public String getChannelUrl() {
        return channelUrl;
    }

    public void setChannelUrl(String channelUrl) {
        this.channelUrl = channelUrl;
    }

    public String getLocationCode() {
        return locationCode;
    }

    public void setLocationCode(String locationCode) {
        this.locationCode = locationCode;
    }

    public String getLocationName() {
        return locationName;
    }

    public void setLocationName(String locationName) {
        this.locationName = locationName;
    }
}
