package com.bxm.localnews.user.enums;

/**
 * @author zhaoyadong 2019/3/7 19:23
 * @desc
 */
public enum CashFlowTypeEnum {

    /**
     * 小程序推广赏金
     */
    APPLET_BOUNTY("APPLET_PROMOTE_BOUNTY", "推广赏金"),

    /**
     * 推广赏金：受邀人进入APP，邀请人获得的推广赏金
     **/
    PROMOTE_BOUNTY("PROMOTE_BOUNTY", "推广赏金"),
    /**
     * 推广赏金：受邀人获得的推广赏金
     **/
    SELF_BOUNTY("SELF_BOUNTY", "新用户红包"),
    /**
     * 用户赏金提现到微信
     */
    WECHAT_WITHDRAWAL("WECHAT_WITHDRAWAL", "提现到微信"),
    /**
     * 首次登陆APP领取新人红包
     */
    RED_PACKET("RED_PACKET", "新用户红包"),
    /**
     * 口令红包
     */
    COMMAND_RED_PACKET("COMMAND_RED_PACKET","口令红包"),
    /**
     * 用户提现失败，资金退回
     */
    FAIL_WITHDRAWAL("FAIL_WITHDRAWAL", "提现失败，资金退回"),

    /**
     * 邀请人与受邀人24小时内没成功绑定关系，邀请人赏金失效
     */
    INVALID_BOUNTY("INVALID_BOUNTY", "推广赏金失效"),

    /**
     * 受邀人赏金失效
     */
    INVALID_PACKET("INVALID_PACKET", "新用户红包失效");

    /**
     * 流水类型
     **/
    private String name;

    /**
     * 流水描述
     **/
    private String desc;

    CashFlowTypeEnum(String name, String desc) {
        this.name = name;
        this.desc = desc;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
