package com.bxm.localnews.user.constant;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;

/**
 * redis 缓存的key值，格式为： {业务类型：模块：子模块:更下级模块} 业务类型： biz:业务 config:配置
 */
public class RedisConfig {

    /**
     * =================================== user 模块相关缓存键值 用户信息 ===================================
     */
    public static KeyGenerator USER_INFO = DefaultKeyGenerator.build("user", "cache", "userInfo");

    /**
     * 用户账户提现弹窗
     */
    public static KeyGenerator USER_WITHDRAW_POP = DefaultKeyGenerator.build("user", "account_withdraw_pop", "");

    /**
     * =================================== message 模块相关缓存键值 ===================================
     */
    /**
     * 用户消息通知红点缓存
     */
    public static KeyGenerator MSG_RED_POINT = DefaultKeyGenerator.build("message", "red_point");

    /**
     * =================================== activity 模块相关缓存键值 用户信息 ===================================
     */

    /**
     * 用户当天完成任务获得奖励金币总数, 有效期:当天
     */
    public static KeyGenerator USER_MISSION_REWARD_SUM_PER_DAY = DefaultKeyGenerator.build("activity", "task",
            "sumreward");

    /**
     * =================================== base 模块相关缓存键值 用户信息 ===================================
     */

    /**
     * channel 所有渠道信息
     */
    public static KeyGenerator BASE_CHANNEL = DefaultKeyGenerator.build("base", "channel");
}
