package com.bxm.localnews.user.enums;

/**
 * Created by Administrator on 2018/3/3.
 */
public enum GoldRewadTypeEnum implements RewardTypeEnum {

    BY_READ("readReward", "阅读"),
    BY_ATTRIBUTE("totalTribute", "徒弟进贡"),
    BY_SHARE("shareArtical", "分享文章"),
    BY_SHOWINCOME("showIncome", "晒收入"),
    BY_SHARE_READ("articalReadByShare", "分享被阅读"),
    BY_OTHERS("otherReward", "其他");

    private String field;

    private String desc;

    GoldRewadTypeEnum(String field, String desc) {
        this.field = field;
        this.desc = desc;
    }

    public static String getDescByField(String field) {
        for (GoldRewadTypeEnum rewadTypeEnum : GoldRewadTypeEnum.values()) {
            if (rewadTypeEnum.getField().equals(field)) {
                return rewadTypeEnum.getDesc();
            }
        }
        return null;
    }

    public String getField() {
        return field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
