package com.bxm.localnews.user.enums;

import java.util.Arrays;
import java.util.stream.Stream;

import com.bxm.localnews.mq.common.constant.PushMessageEnum;

/**
 * Created by Administrator on 2018/2/24.
 */
public enum TaskEnum {
    READ_PUSH_ARTICLE((byte) 11, "阅读推送新闻", new String[]{"otherReward", "goldReward"}, null, null),
    REGISTER((byte) 18, "用户注册", new String[]{"moneyReward", "redPacketMoney"}, null, null),
    SIGN_DAILY((byte) 20, "每日签到", new String[]{"otherReward", "goldReward"}, null, null),
    EXCHANGE_GOODS((byte) 27, "小红花兑换商品", new String[]{"otherReward", "goldReward"}, null, null),
    STORE_ADD_BALANCE((byte) 30, "积分商城添加小红花", new String[]{"otherReward", "goldReward"}, null, null),

    TASK_NEWS_SHARE((byte) 9, "分享内容", new String[]{"shareArtical", "goldReward"}, PushMessageEnum.TASK_COMPLETED, null),
    TASK_NEWS_READ((byte) 10, "看新闻", new String[]{"readReward", "goldReward"}, PushMessageEnum.TASK_COMPLETED, null),
    TASK_INVITED_FRIEND((byte) 31, "邀请好友", new String[]{"otherReward", "goldReward"}, PushMessageEnum.TASK_COMPLETED, null),
    TASK_VIDEO_READ((byte) 32, "看视频", new String[]{"readReward", "goldReward"}, PushMessageEnum.TASK_COMPLETED, null),
    TASK_IMPROVE_INFO((byte) 34, "完善个人资料赚小红花", new String[]{"otherReward", "goldReward"}, PushMessageEnum.TASK_COMPLETED, null),
    TASK_ACTIVATION_VIP((byte) 35, "激活VIP一年", new String[]{"otherReward", "goldReward"}, PushMessageEnum.TASK_COMPLETED, null),
    TASK_FIRST_POST_INTIVATION((byte) 36, "首次发本地圈赚小红花", new String[]{"otherReward", "goldReward"}, PushMessageEnum.TASK_COMPLETED, null),
    TASK_POST_INTIVATION((byte) 37, "发本地圈赚小红花", new String[]{"otherReward", "goldReward"}, PushMessageEnum.TASK_COMPLETED, null),

    TASK_COLLECT_APPLET_MINI((byte) 38, "收藏本地万事通小程序", new String[]{"otherReward", "goldReward"}, PushMessageEnum.TASK_COMPLETED, "red"),
    TASK_FOCUS_WECAHT((byte) 39, "关注微信公众号", new String[]{"otherReward", "goldReward"}, PushMessageEnum.TASK_COMPLETED, "red"),
    TASK_JOIN_WECHAT((byte) 40, "加入便民微信群", new String[]{"otherReward", "goldReward"}, PushMessageEnum.TASK_COMPLETED, "green"),
    TASK_INVITE_FRIEND((byte) 41, "邀请本地的亲朋好友", new String[]{"otherReward", "goldReward"}, PushMessageEnum.TASK_COMPLETED, "green"),
    //app端独有
    TASK_EVERYDAT_SHARE((byte) 42, "每日首次分享新闻/帖子", new String[]{"otherReward", "goldReward"}, PushMessageEnum.TASK_COMPLETED, "red"),
    TASK_COMMENT_NEWS((byte) 43, "发评论赚小红花", new String[]{"otherReward", "goldReward"}, PushMessageEnum.TASK_COMPLETED, "red"),
    TASK_FISRT_BROWSE((byte) 44, "转发赚小红花", new String[]{"otherReward", "goldReward"}, PushMessageEnum.TASK_COMPLETED, "red"),


    TASK_FIRST_LOGIN((byte) 45, "新用户首次登陆", new String[]{"otherReward", "goldReward"}, PushMessageEnum.TASK_COMPLETED, null);

    private byte type;

    private String desc;

    /**
     * 每日统计表中需要变化的列
     */
    private String[] tableColumn;

    private PushMessageEnum pushMessageEnum;

    /**
     * 对应的按钮样式
     */
    private String color;

    TaskEnum(byte type, String desc, String[] tableColumn, PushMessageEnum pushMessageEnum, String color) {
        this.type = type;
        this.desc = desc;
        this.tableColumn = tableColumn;
        this.pushMessageEnum = pushMessageEnum;
        this.color = color;
    }

    public static String getDescByType(byte type) {
        for (TaskEnum taskTypeEnum : TaskEnum.values()) {
            if (taskTypeEnum.getType() == type) {
                return taskTypeEnum.getDesc();
            }
        }
        return null;
    }

    public static String[] getTableColumByType(byte type) {
        for (TaskEnum taskTypeEnum : TaskEnum.values()) {
            if (taskTypeEnum.getType() == type) {
                return taskTypeEnum.getTableColumn();
            }
        }
        return null;
    }

    public static PushMessageEnum getPushMessageEnumByDesc(String desc) {
        return Stream.of(TaskEnum.values()).filter(taskTypeEnum ->
                desc.equals(taskTypeEnum.getDesc())).findAny().get().getPushMessageEnum();
    }

    public static TaskEnum getTaskByDesc(String desc) {
        return Arrays.asList(TaskEnum.values()).stream().filter(taskEnum -> desc.equals(taskEnum.getDesc())).findFirst().get();
    }


    /**
     * 根据type获取任务枚举类型
     *
     * @param type 任务类型
     * @return 返回task
     */
    public static TaskEnum getTaskByType(byte type) {
        return Arrays.asList(TaskEnum.values()).stream().filter(taskEnum -> type == (taskEnum.getType())).findFirst().get();
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String[] getTableColumn() {
        return this.tableColumn;
    }

    public void setTableColumn(String[] tableColumn) {
        this.tableColumn = tableColumn;
    }

    public PushMessageEnum getPushMessageEnum() {
        return pushMessageEnum;
    }

    public String getColor() {
        return color;
    }

    public void setColor(String color) {
        this.color = color;
    }
}
