package com.bxm.localnews.user.enums;

import lombok.Getter;
import lombok.extern.slf4j.Slf4j;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lowi
 * @date 2020/12/17 20:55
 */
@Getter
@Slf4j
public enum EarningsCashShowTypeEnum {
    /**
     * 金额展示类型
     * 1: 展示为 自购| 佣金 ￥100
     * 2: 展示为 购买人：刘亦菲 电话：110 佣金：￥100
     * 3: 展示为 佣金：￥100
     * 4: 展示为 被邀请人 | 佣金：￥100
     * 5: 邀请开通vip特殊处理
     */
    SELF_SELL_COMMISSION(1),
    NAME_PHONE_COMMISSION(2),
    COMMISSION(3),
    NAME_COMMISSION(4),
    OPENING_VIP_TYPE(5),
    ;

    private Integer type;

    static final Map<Integer, Integer> CONVERT_MAP = new HashMap<>();

    EarningsCashShowTypeEnum(Integer type) {
        this.type = type;
    }

    private static void convertMap() {
        //自购的转换为  展示为 自购| 佣金 ￥100
        CONVERT_MAP.put(UserEarningsTypeEnum.TB_SELF_SELL_COMMISSION.getEarningsType(), SELF_SELL_COMMISSION.getType());
        CONVERT_MAP.put(UserEarningsTypeEnum.ELM_SELF_SELL_COMMISSION.getEarningsType(), SELF_SELL_COMMISSION.getType());
        CONVERT_MAP.put(UserEarningsTypeEnum.MEITUAN_COMMISSION.getEarningsType(), SELF_SELL_COMMISSION.getType());
        CONVERT_MAP.put(UserEarningsTypeEnum.GOODS_SELF_SELL_COMMISSION.getEarningsType(), SELF_SELL_COMMISSION.getType());
        //分享的转换为  展示为 购买人：刘亦菲 电话：110 佣金：￥100
        CONVERT_MAP.put(UserEarningsTypeEnum.TB_SHARE_COMMISSION.getEarningsType(), NAME_PHONE_COMMISSION.getType());
        CONVERT_MAP.put(UserEarningsTypeEnum.TB_TEAM_COMMISSION.getEarningsType(), NAME_PHONE_COMMISSION.getType());
        CONVERT_MAP.put(UserEarningsTypeEnum.ELM_SHARE_COMMISSION.getEarningsType(), NAME_PHONE_COMMISSION.getType());
        CONVERT_MAP.put(UserEarningsTypeEnum.GOODS_SHARE_COMMISSION.getEarningsType(), NAME_PHONE_COMMISSION.getType());
        CONVERT_MAP.put(UserEarningsTypeEnum.GOODS_TEAM_COMMISSION.getEarningsType(), NAME_PHONE_COMMISSION.getType());
        //帖子奖励转换为  展示为 佣金：￥100
        CONVERT_MAP.put(UserEarningsTypeEnum.POST_REWARD.getEarningsType(), COMMISSION.getType());
        CONVERT_MAP.put(UserEarningsTypeEnum.SHARE_HOT_POST.getEarningsType(), COMMISSION.getType());
        //好友注册、发帖奖励转换为 展示为 被邀请人 | 佣金：￥100
        CONVERT_MAP.put(UserEarningsTypeEnum.FRIENDS_REGISTER_REWARD.getEarningsType(), NAME_COMMISSION.getType());
        CONVERT_MAP.put(UserEarningsTypeEnum.FRIENDS_POST_REWARD.getEarningsType(), NAME_COMMISSION.getType());
        //5: 邀请开通vip特殊处理
        CONVERT_MAP.put(UserEarningsTypeEnum.VIP_SHARE_COMMISSION.getEarningsType(), OPENING_VIP_TYPE.getType());
    }

    public static Integer getShowType(Integer earningsType) {
        if (CONVERT_MAP.size() == 0) {
            convertMap();
        }
        return CONVERT_MAP.get(earningsType);
    }
}
